/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.utils.nodetool.function;

import io.airlift.airline.Command;
import java.util.Map;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.utils.nodetool.ClusterMonitorMBean;
import org.apache.iotdb.cluster.utils.nodetool.Printer;
import org.apache.iotdb.cluster.utils.nodetool.function.NodeToolCmd;

@Command(name="slot", description="Print slot information of all data groups")
public class Slot
extends NodeToolCmd {
    @Override
    public void execute(ClusterMonitorMBean proxy) {
        Map<PartitionGroup, Integer> raftGroupMapSlotNum = proxy.getSlotNumOfAllNode();
        if (raftGroupMapSlotNum == null) {
            Printer.msgPrintln("The cluster is being created.");
            return;
        }
        this.showInfo(raftGroupMapSlotNum);
    }

    private void showInfo(Map<PartitionGroup, Integer> raftGroupMapSlotNum) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("%-50s  %20s", "Raft group", "Slot Number"));
        Printer.msgPrintln(builder.toString());
        for (Map.Entry<PartitionGroup, Integer> entry : raftGroupMapSlotNum.entrySet()) {
            builder = new StringBuilder();
            PartitionGroup raftGroup = entry.getKey();
            Integer slotNum = entry.getValue();
            builder.append('(');
            if (!raftGroup.isEmpty()) {
                builder.append(Slot.nodeToString((Node)raftGroup.get(0)));
            }
            for (int i = 1; i < raftGroup.size(); ++i) {
                builder.append(", ").append(Slot.nodeToString((Node)raftGroup.get(i)));
            }
            builder.append("),id=").append(raftGroup.getRaftId());
            Printer.msgPrintln(String.format("%-50s->%20s", builder.toString(), slotNum));
        }
    }
}

