/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.control.clientsession;

import java.time.ZoneId;
import java.util.Set;
import java.util.TimeZone;
import org.apache.iotdb.db.conf.IoTDBConstant;
import org.apache.iotdb.service.rpc.thrift.TSConnectionInfo;
import org.apache.iotdb.service.rpc.thrift.TSConnectionType;

public abstract class IClientSession {
    @Deprecated
    private long id;
    private IoTDBConstant.ClientVersion clientVersion;
    private ZoneId zoneId;
    private TimeZone timeZone;
    private String username;
    private boolean login = false;
    private long logInTime;
    private boolean enableAudit = true;

    abstract String getClientAddress();

    abstract int getClientPort();

    abstract TSConnectionType getConnectionType();

    abstract String getConnectionId();

    public void setClientVersion(IoTDBConstant.ClientVersion clientVersion) {
        this.clientVersion = clientVersion;
    }

    public IoTDBConstant.ClientVersion getClientVersion() {
        return this.clientVersion;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
        this.timeZone = TimeZone.getTimeZone(zoneId);
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        this.zoneId = timeZone.toZoneId();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isLogin() {
        return this.login;
    }

    public void setLogin(boolean login) {
        this.login = login;
    }

    public void setLogInTime(long logInTime) {
        this.logInTime = logInTime;
    }

    public long getLogInTime() {
        return this.logInTime;
    }

    @Deprecated
    public long getId() {
        return this.id;
    }

    @Deprecated
    public void setId(long id) {
        this.id = id;
    }

    public boolean isEnableAudit() {
        return this.enableAudit;
    }

    public void setEnableAudit(boolean enableAudit) {
        this.enableAudit = enableAudit;
    }

    public String toString() {
        return String.format("%d-%s:%s:%d", this.getId(), this.getUsername(), this.getClientAddress(), this.getClientPort());
    }

    public TSConnectionInfo convertToTSConnectionInfo() {
        return new TSConnectionInfo(this.getUsername(), this.getLogInTime(), this.getConnectionId(), this.getConnectionType());
    }

    public abstract Set<Long> getStatementIds();
}

