/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.client;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.iotdb.cluster.client.ClientCategory;
import org.apache.iotdb.cluster.client.ClientPoolFactory;
import org.apache.iotdb.cluster.client.IClientManager;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftService;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientManager
implements IClientManager {
    private static final Logger logger = LoggerFactory.getLogger(ClientManager.class);
    private Map<ClientCategory, KeyedObjectPool<Node, RaftService.AsyncClient>> asyncClientPoolMap;
    private Map<ClientCategory, KeyedObjectPool<Node, RaftService.Client>> syncClientPoolMap;
    private final ClientPoolFactory clientPoolFactory = new ClientPoolFactory();

    public ClientManager(boolean isAsyncMode, Type type) {
        this.clientPoolFactory.setClientManager(this);
        if (isAsyncMode) {
            this.asyncClientPoolMap = Maps.newHashMap();
            this.constructAsyncClientMap(type);
        } else {
            this.syncClientPoolMap = Maps.newHashMap();
            this.constructSyncClientMap(type);
        }
    }

    private void constructAsyncClientMap(Type type) {
        switch (type) {
            case RequestForwardClient: {
                this.asyncClientPoolMap.put(ClientCategory.DATA, (KeyedObjectPool<Node, RaftService.AsyncClient>)this.clientPoolFactory.createAsyncDataPool(ClientCategory.DATA));
                break;
            }
            case MetaGroupClient: {
                this.asyncClientPoolMap.put(ClientCategory.META, (KeyedObjectPool<Node, RaftService.AsyncClient>)this.clientPoolFactory.createAsyncMetaPool(ClientCategory.META));
                this.asyncClientPoolMap.put(ClientCategory.META_HEARTBEAT, (KeyedObjectPool<Node, RaftService.AsyncClient>)this.clientPoolFactory.createAsyncMetaPool(ClientCategory.META_HEARTBEAT));
                break;
            }
            case DataGroupClient: {
                this.asyncClientPoolMap.put(ClientCategory.DATA, (KeyedObjectPool<Node, RaftService.AsyncClient>)this.clientPoolFactory.createAsyncDataPool(ClientCategory.DATA));
                this.asyncClientPoolMap.put(ClientCategory.DATA_HEARTBEAT, (KeyedObjectPool<Node, RaftService.AsyncClient>)this.clientPoolFactory.createAsyncDataPool(ClientCategory.DATA_HEARTBEAT));
                this.asyncClientPoolMap.put(ClientCategory.DATA_ASYNC_APPEND_CLIENT, (KeyedObjectPool<Node, RaftService.AsyncClient>)this.clientPoolFactory.createSingleManagerAsyncDataPool());
                break;
            }
            default: {
                logger.warn("unsupported ClientManager type: {}", (Object)type);
            }
        }
    }

    private void constructSyncClientMap(Type type) {
        switch (type) {
            case RequestForwardClient: {
                this.syncClientPoolMap.put(ClientCategory.DATA, (KeyedObjectPool<Node, RaftService.Client>)this.clientPoolFactory.createSyncDataPool(ClientCategory.DATA));
                break;
            }
            case MetaGroupClient: {
                this.syncClientPoolMap.put(ClientCategory.META, (KeyedObjectPool<Node, RaftService.Client>)this.clientPoolFactory.createSyncMetaPool(ClientCategory.META));
                this.syncClientPoolMap.put(ClientCategory.META_HEARTBEAT, (KeyedObjectPool<Node, RaftService.Client>)this.clientPoolFactory.createSyncMetaPool(ClientCategory.META_HEARTBEAT));
                break;
            }
            case DataGroupClient: {
                this.syncClientPoolMap.put(ClientCategory.DATA, (KeyedObjectPool<Node, RaftService.Client>)this.clientPoolFactory.createSyncDataPool(ClientCategory.DATA));
                this.syncClientPoolMap.put(ClientCategory.DATA_HEARTBEAT, (KeyedObjectPool<Node, RaftService.Client>)this.clientPoolFactory.createSyncDataPool(ClientCategory.DATA_HEARTBEAT));
                break;
            }
            default: {
                logger.warn("unsupported ClientManager type: {}", (Object)type);
            }
        }
    }

    @Override
    public RaftService.AsyncClient borrowAsyncClient(Node node, ClientCategory category) throws IOException {
        KeyedObjectPool<Node, RaftService.AsyncClient> pool;
        RaftService.AsyncClient client = null;
        if (this.asyncClientPoolMap != null && (pool = this.asyncClientPoolMap.get((Object)category)) != null) {
            try {
                client = (RaftService.AsyncClient)pool.borrowObject((Object)node);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                logger.error("BorrowAsyncClient fail.", (Throwable)e);
            }
        } else {
            logger.warn("BorrowSyncClient invoke on unsupported mode or category: Node:{}, ClientCategory:{}, isSyncMode:{}", new Object[]{node, this.clientPoolFactory, this.syncClientPoolMap != null});
        }
        return client;
    }

    @Override
    public RaftService.Client borrowSyncClient(Node node, ClientCategory category) throws IOException {
        KeyedObjectPool<Node, RaftService.Client> pool;
        RaftService.Client client = null;
        if (this.syncClientPoolMap != null && (pool = this.syncClientPoolMap.get((Object)category)) != null) {
            try {
                client = (RaftService.Client)pool.borrowObject((Object)node);
            }
            catch (TTransportException e) {
                throw new IOException(e);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                logger.error("BorrowSyncClient fail.", (Throwable)e);
            }
        } else {
            logger.warn("BorrowSyncClient invoke on unsupported mode or category: Node:{}, ClientCategory:{}, isSyncMode:{}", new Object[]{node, this.clientPoolFactory, this.syncClientPoolMap != null});
        }
        return client;
    }

    @Override
    public void returnAsyncClient(RaftService.AsyncClient client, Node node, ClientCategory category) {
        if (client != null && node != null) {
            try {
                this.asyncClientPoolMap.get((Object)category).returnObject((Object)node, (Object)client);
            }
            catch (Exception e) {
                logger.error("AsyncClient return error: {}", (Object)client, (Object)e);
            }
        }
    }

    @Override
    public void returnSyncClient(RaftService.Client client, Node node, ClientCategory category) {
        if (client != null && node != null) {
            try {
                this.syncClientPoolMap.get((Object)category).returnObject((Object)node, (Object)client);
            }
            catch (Exception e) {
                logger.error("SyncClient return error: {}", (Object)client, (Object)e);
            }
        }
    }

    public static enum Type {
        RequestForwardClient,
        DataGroupClient,
        MetaGroupClient;

    }
}

