/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.cq;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.cq.ContinuousQueryTask;
import org.apache.iotdb.db.exception.ContinuousQueryException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.logical.crud.QueryOperator;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimePlan;
import org.apache.iotdb.db.qp.physical.sys.CreateContinuousQueryPlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.TypeInferenceUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;

public class ContinuousQuerySchemaCheckTask
extends ContinuousQueryTask {
    public static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();

    public ContinuousQuerySchemaCheckTask(CreateContinuousQueryPlan continuousQueryPlan, long windowEndTimestamp) {
        super(continuousQueryPlan, windowEndTimestamp);
    }

    @Override
    protected void doInsert(String sql, QueryOperator queryOperator, GroupByTimePlan queryPlan, QueryDataSet queryDataSet) throws MetadataException, StorageEngineException, IOException {
        HashSet<PartialPath> targetPaths = new HashSet<PartialPath>(this.generateTargetPaths(queryDataSet.getPaths()));
        this.checkTargetPathNumber(queryDataSet, targetPaths);
        this.checkTargetPathDataType(queryPlan, targetPaths);
        this.tryExecuteQueryOnce(queryDataSet);
    }

    private void checkTargetPathNumber(QueryDataSet queryDataSet, Set<PartialPath> targetPaths) throws ContinuousQueryException {
        if (targetPaths.size() != queryDataSet.getDataTypes().size()) {
            throw new ContinuousQueryException("the target paths generated by the pattern in into clause are duplicated. please change the pattern.");
        }
    }

    private void checkTargetPathDataType(GroupByTimePlan queryPlan, Set<PartialPath> targetPaths) throws MetadataException, ContinuousQueryException {
        TSDataType sourceDataType = TypeInferenceUtils.getAggrDataType(queryPlan.getAggregations().get(0), queryPlan.getDataTypes().get(0));
        for (PartialPath targetPath : targetPaths) {
            try {
                TSDataType targetPathDataType = IoTDB.metaManager.getSeriesSchema(targetPath).getType();
                if (sourceDataType.equals((Object)targetPathDataType)) continue;
                throw new ContinuousQueryException(String.format("target path (%s) data type (%s) and source data type (%s) dose not match.", targetPath.getFullPath(), targetPathDataType.name(), sourceDataType.name()));
            }
            catch (PathNotExistException pathNotExistException) {
                if (CONFIG.isAutoCreateSchemaEnabled()) continue;
                throw new ContinuousQueryException(String.format("target path (%s) dose not exist.", targetPath.getFullPath()));
            }
        }
    }

    private void tryExecuteQueryOnce(QueryDataSet queryDataSet) throws IOException {
        if (queryDataSet.hasNext()) {
            queryDataSet.next();
        }
    }
}

