/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.expression.util;

import org.apache.iotdb.tsfile.read.expression.IBinaryExpression;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.IUnaryExpression;

public class ExpressionPrinter {
    private static final int MAX_DEPTH = 100;
    private static final char PREFIX_CHAR = '\t';
    private static final String[] PREFIX = new String[100];

    public static void print(IExpression expression) {
        ExpressionPrinter.print(expression, 0);
    }

    private static void print(IExpression expression, int level) {
        if (expression instanceof IUnaryExpression) {
            System.out.println(ExpressionPrinter.getPrefix(level) + expression);
        } else {
            System.out.println(ExpressionPrinter.getPrefix(level) + (Object)((Object)expression.getType()) + ":");
            ExpressionPrinter.print(((IBinaryExpression)expression).getLeft(), level + 1);
            ExpressionPrinter.print(((IBinaryExpression)expression).getRight(), level + 1);
        }
    }

    private static String getPrefix(int count) {
        if (count < 100) {
            return PREFIX[count];
        }
        return PREFIX[99];
    }

    static {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            ExpressionPrinter.PREFIX[i] = stringBuilder.toString();
            stringBuilder.append('\t');
        }
    }
}

