/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.inner.sizetiered;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.CompactionUtils;
import org.apache.iotdb.db.engine.compaction.TsFileIdentifier;
import org.apache.iotdb.db.engine.compaction.inner.InnerSpaceCompactionExceptionHandler;
import org.apache.iotdb.db.engine.compaction.inner.sizetiered.SizeTieredCompactionTask;
import org.apache.iotdb.db.engine.compaction.inner.utils.InnerSpaceCompactionUtils;
import org.apache.iotdb.db.engine.compaction.task.AbstractCompactionTask;
import org.apache.iotdb.db.engine.compaction.utils.log.CompactionLogAnalyzer;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SizeTieredCompactionRecoverTask
extends SizeTieredCompactionTask {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    protected File compactionLogFile;
    protected String dataDir;
    protected String logicalStorageGroupName;
    protected String virtualStorageGroup;

    public SizeTieredCompactionRecoverTask(String logicalStorageGroupName, String virtualStorageGroup, long timePartition, File compactionLogFile, String dataDir, boolean sequence, AtomicInteger currentTaskNum, TsFileManager tsFileManager) {
        super(logicalStorageGroupName, virtualStorageGroup, timePartition, tsFileManager, new ArrayList<TsFileResource>(), sequence, currentTaskNum);
        this.compactionLogFile = compactionLogFile;
        this.dataDir = dataDir;
        this.logicalStorageGroupName = logicalStorageGroupName;
        this.virtualStorageGroup = virtualStorageGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void doCompaction() {
        block38: {
            block32: {
                block35: {
                    block40: {
                        block36: {
                            block33: {
                                block39: {
                                    block34: {
                                        handleSuccess = true;
                                        SizeTieredCompactionRecoverTask.LOGGER.info("{} [Compaction][Recover] inner space compaction log is {}", (Object)this.fullStorageGroupName, (Object)this.compactionLogFile);
                                        if (!this.compactionLogFile.exists()) break block32;
                                        SizeTieredCompactionRecoverTask.LOGGER.info("{}-{} [Compaction][Recover] inner space compaction log file {} exists, start to recover it", new Object[]{this.logicalStorageGroupName, this.virtualStorageGroup, this.compactionLogFile});
                                        logAnalyzer = new CompactionLogAnalyzer(this.compactionLogFile);
                                        if (this.isOldLog()) {
                                            logAnalyzer.analyzeOldInnerCompactionLog();
                                        } else {
                                            logAnalyzer.analyze();
                                        }
                                        sourceFileIdentifiers = logAnalyzer.getSourceFileInfos();
                                        targetFileIdentifier = logAnalyzer.getTargetFileInfos().get(0);
                                        if (targetFileIdentifier != null && !sourceFileIdentifiers.isEmpty()) break block33;
                                        SizeTieredCompactionRecoverTask.LOGGER.info("{}-{} [Compaction][Recover] incomplete log file, abort recover", (Object)this.logicalStorageGroupName, (Object)this.virtualStorageGroup);
                                        if (handleSuccess) break block34;
                                        SizeTieredCompactionRecoverTask.LOGGER.error("{} [Compaction][Recover] Failed to recover compaction, set allowCompaction to false", (Object)this.fullStorageGroupName);
                                        this.tsFileManager.setAllowCompaction(false);
                                        break block39;
                                    }
                                    if (this.compactionLogFile.exists()) {
                                        try {
                                            SizeTieredCompactionRecoverTask.LOGGER.info("{} [Compaction][Recover] Recover compaction successfully, delete log file {}", (Object)this.fullStorageGroupName, (Object)this.compactionLogFile);
                                            FileUtils.delete((File)this.compactionLogFile);
                                        }
                                        catch (IOException e) {
                                            SizeTieredCompactionRecoverTask.LOGGER.error("{} [Compaction][Recover] Exception occurs while deleting log file {}, set allowCompaction to false", new Object[]{this.fullStorageGroupName, this.compactionLogFile, e});
                                            this.tsFileManager.setAllowCompaction(false);
                                        }
                                    }
                                }
                                return;
                            }
                            isAllSourcesFileExisted = true;
                            for (TsFileIdentifier sourceFileIdentifier : sourceFileIdentifiers) {
                                sourceFile = sourceFileIdentifier.getFileFromDataDirs();
                                if (sourceFile != null) continue;
                                isAllSourcesFileExisted = false;
                                break;
                            }
                            targetResource = null;
                            tmpTargetFile = targetFileIdentifier.getFileFromDataDirs();
                            targetFile = this.getFileFromDataDirs(targetFileIdentifier.getFilePath().replace(".inner", ".tsfile"));
                            if (tmpTargetFile != null) {
                                targetResource = new TsFileResource(tmpTargetFile);
                            } else if (targetFile != null) {
                                targetResource = new TsFileResource(targetFile);
                            }
                            if (!isAllSourcesFileExisted) ** GOTO lbl76
                            sourceResources = new ArrayList<TsFileResource>();
                            for (TsFileIdentifier sourceFileIdentifier : sourceFileIdentifiers) {
                                sourceResources.add(new TsFileResource(sourceFileIdentifier.getFileFromDataDirs()));
                            }
                            if (targetResource != null) break block35;
                            SizeTieredCompactionRecoverTask.LOGGER.info("{}-{} [Compaction][Recover] Target file {} does not exist.", new Object[]{this.logicalStorageGroupName, this.virtualStorageGroup, targetFileIdentifier.getFilePath()});
                            CompactionUtils.deleteCompactionModsFile(sourceResources, Collections.emptyList());
                            if (handleSuccess) break block36;
                            SizeTieredCompactionRecoverTask.LOGGER.error("{} [Compaction][Recover] Failed to recover compaction, set allowCompaction to false", (Object)this.fullStorageGroupName);
                            this.tsFileManager.setAllowCompaction(false);
                            break block40;
                        }
                        if (this.compactionLogFile.exists()) {
                            try {
                                SizeTieredCompactionRecoverTask.LOGGER.info("{} [Compaction][Recover] Recover compaction successfully, delete log file {}", (Object)this.fullStorageGroupName, (Object)this.compactionLogFile);
                                FileUtils.delete((File)this.compactionLogFile);
                            }
                            catch (IOException e) {
                                SizeTieredCompactionRecoverTask.LOGGER.error("{} [Compaction][Recover] Exception occurs while deleting log file {}, set allowCompaction to false", new Object[]{this.fullStorageGroupName, this.compactionLogFile, e});
                                this.tsFileManager.setAllowCompaction(false);
                            }
                        }
                    }
                    return;
                }
                try {
                    handleSuccess = InnerSpaceCompactionExceptionHandler.handleWhenAllSourceFilesExist(this.fullStorageGroupName, targetResource, sourceResources, this.tsFileResourceList, this.tsFileManager, true);
                    break block32;
lbl76:
                    // 1 sources

                    handleSuccess = this.handleWithoutAllSourceFilesExist(sourceFileIdentifiers);
                }
                catch (IOException e) {
                    block37: {
                        try {
                            SizeTieredCompactionRecoverTask.LOGGER.error("recover inner space compaction error", (Throwable)e);
                            if (handleSuccess) break block37;
                        }
                        catch (Throwable var12_17) {
                            if (!handleSuccess) {
                                SizeTieredCompactionRecoverTask.LOGGER.error("{} [Compaction][Recover] Failed to recover compaction, set allowCompaction to false", (Object)this.fullStorageGroupName);
                                this.tsFileManager.setAllowCompaction(false);
                            } else if (this.compactionLogFile.exists()) {
                                try {
                                    SizeTieredCompactionRecoverTask.LOGGER.info("{} [Compaction][Recover] Recover compaction successfully, delete log file {}", (Object)this.fullStorageGroupName, (Object)this.compactionLogFile);
                                    FileUtils.delete((File)this.compactionLogFile);
                                }
                                catch (IOException e) {
                                    SizeTieredCompactionRecoverTask.LOGGER.error("{} [Compaction][Recover] Exception occurs while deleting log file {}, set allowCompaction to false", new Object[]{this.fullStorageGroupName, this.compactionLogFile, e});
                                    this.tsFileManager.setAllowCompaction(false);
                                }
                            }
                            throw var12_17;
                        }
                        SizeTieredCompactionRecoverTask.LOGGER.error("{} [Compaction][Recover] Failed to recover compaction, set allowCompaction to false", (Object)this.fullStorageGroupName);
                        this.tsFileManager.setAllowCompaction(false);
                        break block38;
                    }
                    if (this.compactionLogFile.exists()) {
                        try {
                            SizeTieredCompactionRecoverTask.LOGGER.info("{} [Compaction][Recover] Recover compaction successfully, delete log file {}", (Object)this.fullStorageGroupName, (Object)this.compactionLogFile);
                            FileUtils.delete((File)this.compactionLogFile);
                        }
                        catch (IOException e) {
                            SizeTieredCompactionRecoverTask.LOGGER.error("{} [Compaction][Recover] Exception occurs while deleting log file {}, set allowCompaction to false", new Object[]{this.fullStorageGroupName, this.compactionLogFile, e});
                            this.tsFileManager.setAllowCompaction(false);
                        }
                    } else {
                        ** GOTO lbl125
                    }
                }
            }
            if (!handleSuccess) {
                SizeTieredCompactionRecoverTask.LOGGER.error("{} [Compaction][Recover] Failed to recover compaction, set allowCompaction to false", (Object)this.fullStorageGroupName);
                this.tsFileManager.setAllowCompaction(false);
            } else if (this.compactionLogFile.exists()) {
                try {
                    SizeTieredCompactionRecoverTask.LOGGER.info("{} [Compaction][Recover] Recover compaction successfully, delete log file {}", (Object)this.fullStorageGroupName, (Object)this.compactionLogFile);
                    FileUtils.delete((File)this.compactionLogFile);
                }
                catch (IOException e) {
                    SizeTieredCompactionRecoverTask.LOGGER.error("{} [Compaction][Recover] Exception occurs while deleting log file {}, set allowCompaction to false", new Object[]{this.fullStorageGroupName, this.compactionLogFile, e});
                    this.tsFileManager.setAllowCompaction(false);
                }
            }
        }
    }

    @Override
    public boolean equalsOtherTask(AbstractCompactionTask other) {
        if (other instanceof SizeTieredCompactionRecoverTask) {
            SizeTieredCompactionRecoverTask otherTask = (SizeTieredCompactionRecoverTask)other;
            return this.compactionLogFile.equals(otherTask.compactionLogFile) && this.dataDir.equals(otherTask.dataDir);
        }
        return false;
    }

    @Override
    public boolean checkValidAndSetMerging() {
        return this.compactionLogFile.exists();
    }

    private boolean handleWithoutAllSourceFilesExist(List<TsFileIdentifier> sourceFileIdentifiers) {
        boolean handleSuccess = true;
        ArrayList<TsFileResource> remainSourceTsFileResources = new ArrayList<TsFileResource>();
        for (TsFileIdentifier sourceFileIdentifier : sourceFileIdentifiers) {
            File sourceFile = sourceFileIdentifier.getFileFromDataDirs();
            if (sourceFile != null) {
                TsFileResource resource = new TsFileResource(sourceFile);
                resource.setStatus(TsFileResourceStatus.CLOSED);
                remainSourceTsFileResources.add(resource);
            } else {
                File resourceFile = this.getFileFromDataDirs(sourceFileIdentifier.getFilePath() + ".resource");
                if (resourceFile != null && !resourceFile.delete()) {
                    LOGGER.error("{}-{} [Compaction][Recover] fail to delete target file {}, this may cause data incorrectness", new Object[]{this.logicalStorageGroupName, this.virtualStorageGroup, resourceFile});
                    handleSuccess = false;
                }
            }
            File compactionModFile = this.getFileFromDataDirs(sourceFileIdentifier.getFilePath() + ".compaction.mods");
            File modFile = this.getFileFromDataDirs(sourceFileIdentifier.getFilePath() + ".mods");
            if (compactionModFile != null && !compactionModFile.delete()) {
                LOGGER.error("{}-{} [Compaction][Recover] fail to delete target file {}, this may cause data incorrectness", new Object[]{this.logicalStorageGroupName, this.virtualStorageGroup, compactionModFile});
                handleSuccess = false;
            }
            if (modFile == null || modFile.delete()) continue;
            LOGGER.error("{}-{} [Compaction][Recover] fail to delete target file {}, this may cause data incorrectness", new Object[]{this.logicalStorageGroupName, this.virtualStorageGroup, modFile});
            handleSuccess = false;
        }
        if (!InnerSpaceCompactionUtils.deleteTsFilesInDisk(remainSourceTsFileResources, this.fullStorageGroupName)) {
            LOGGER.error("{}-{} [Compaction][Recover] fail to delete remaining source files.", (Object)this.logicalStorageGroupName, (Object)this.virtualStorageGroup);
            handleSuccess = false;
        }
        return handleSuccess;
    }

    private File getFileFromDataDirs(String filePath) {
        String[] dataDirs;
        for (String dataDir : dataDirs = IoTDBDescriptor.getInstance().getConfig().getDataDirs()) {
            File f = new File(dataDir, filePath);
            if (!f.exists()) continue;
            return f;
        }
        return null;
    }

    private boolean isOldLog() {
        return this.compactionLogFile.getName().startsWith(this.tsFileManager.getStorageGroupName());
    }
}

