/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.crud;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.LogicalOperatorException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.constant.FilterConstant;
import org.apache.iotdb.db.qp.logical.crud.FunctionOperator;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.IUnaryExpression;
import org.apache.iotdb.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.iotdb.tsfile.read.expression.impl.SingleSeriesExpression;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.ValueFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.StringContainer;

public class InOperator
extends FunctionOperator {
    private boolean not;
    protected Set<String> values;

    public InOperator(FilterConstant.FilterType filterType, PartialPath path, boolean not, Set<String> values) {
        super(filterType);
        this.singlePath = path;
        this.values = values;
        this.not = not;
        this.isLeaf = true;
        this.isSingle = true;
    }

    public Set<String> getValues() {
        return this.values;
    }

    public boolean getNot() {
        return this.not;
    }

    @Override
    public void reverseFunc() {
        this.not = !this.not;
    }

    @Override
    protected Pair<IUnaryExpression, String> transformToSingleQueryFilter(Map<PartialPath, TSDataType> pathTSDataTypeHashMap) throws LogicalOperatorException, MetadataException {
        IUnaryExpression ret;
        TSDataType type = pathTSDataTypeHashMap.get(this.singlePath);
        if (type == null) {
            throw new MetadataException("given seriesPath:{" + this.singlePath.getFullPath() + "} don't exist in metadata");
        }
        switch (type) {
            case INT32: {
                HashSet<Integer> integerValues = new HashSet<Integer>();
                for (String val : this.values) {
                    integerValues.add(Integer.valueOf(val));
                }
                ret = In.getUnaryExpression(this.singlePath, integerValues, this.not);
                break;
            }
            case INT64: {
                HashSet<Long> longValues = new HashSet<Long>();
                for (String val : this.values) {
                    longValues.add(Long.valueOf(val));
                }
                ret = In.getUnaryExpression(this.singlePath, longValues, this.not);
                break;
            }
            case BOOLEAN: {
                HashSet<Boolean> booleanValues = new HashSet<Boolean>();
                for (String val : this.values) {
                    booleanValues.add(Boolean.valueOf(val));
                }
                ret = In.getUnaryExpression(this.singlePath, booleanValues, this.not);
                break;
            }
            case FLOAT: {
                HashSet<Float> floatValues = new HashSet<Float>();
                for (String val : this.values) {
                    floatValues.add(Float.valueOf(Float.parseFloat(val)));
                }
                ret = In.getUnaryExpression(this.singlePath, floatValues, this.not);
                break;
            }
            case DOUBLE: {
                HashSet<Double> doubleValues = new HashSet<Double>();
                for (String val : this.values) {
                    doubleValues.add(Double.parseDouble(val));
                }
                ret = In.getUnaryExpression(this.singlePath, doubleValues, this.not);
                break;
            }
            case TEXT: {
                HashSet<Binary> binaryValues = new HashSet<Binary>();
                for (String val : this.values) {
                    binaryValues.add(val.startsWith("'") && val.endsWith("'") || val.startsWith("\"") && val.endsWith("\"") ? new Binary(val.substring(1, val.length() - 1)) : new Binary(val));
                }
                ret = In.getUnaryExpression(this.singlePath, binaryValues, this.not);
                break;
            }
            default: {
                throw new LogicalOperatorException(type.toString(), "");
            }
        }
        return new Pair((Object)ret, (Object)this.singlePath.getFullPath());
    }

    @Override
    public String showTree(int spaceNum) {
        StringContainer sc = new StringContainer();
        for (int i = 0; i < spaceNum; ++i) {
            sc.addTail(new String[]{"  "});
        }
        sc.addTail(new Object[]{this.singlePath.getFullPath(), this.getFilterSymbol(), this.not, this.values, ", single\n"});
        return sc.toString();
    }

    @Override
    public InOperator copy() {
        InOperator ret = new InOperator(this.filterType, this.singlePath.clone(), this.not, new HashSet<String>(this.values));
        ret.isLeaf = this.isLeaf;
        ret.isSingle = this.isSingle;
        ret.pathSet = this.pathSet;
        return ret;
    }

    @Override
    public String toString() {
        ArrayList<String> valuesList = new ArrayList<String>(this.values);
        Collections.sort(valuesList);
        return "[" + this.singlePath.getFullPath() + this.getFilterSymbol() + this.not + valuesList + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InOperator that = (InOperator)o;
        return Objects.equals(this.singlePath, that.singlePath) && this.values.containsAll(that.values) && this.values.size() == that.values.size() && this.not == that.not;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.singlePath, this.not, this.values);
    }

    private static class In {
        private In() {
        }

        public static <T extends Comparable<T>> IUnaryExpression getUnaryExpression(Path path, Set<T> values, boolean not) {
            if (path != null && path.toString().equals("time")) {
                return new GlobalTimeExpression((Filter)TimeFilter.in(values, (boolean)not));
            }
            return new SingleSeriesExpression(path, (Filter)ValueFilter.in(values, (boolean)not));
        }

        public <T extends Comparable<T>> Filter getValueFilter(T value) {
            return ValueFilter.notEq(value);
        }
    }
}

