/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.encoding.decoder;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.exception.encoding.TsFileDecodingException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteForEncodingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class BitmapDecoder
extends Decoder {
    private static final Logger logger = LoggerFactory.getLogger(BitmapDecoder.class);
    private int length;
    private int number;
    private int currentCount;
    private ByteBuffer byteCache;
    private Map<Integer, byte[]> buffer;

    public BitmapDecoder() {
        super(TSEncoding.BITMAP);
        this.reset();
        logger.debug("tsfile-encoding BitmapDecoder: init bitmap decoder");
    }

    @Override
    public int readInt(ByteBuffer buffer) {
        if (this.currentCount == 0) {
            this.reset();
            this.getLengthAndNumber(buffer);
            this.readNext();
        }
        int result = 0;
        int index = (this.number - this.currentCount) / 8;
        int offset = 7 - (this.number - this.currentCount) % 8;
        for (Map.Entry<Integer, byte[]> entry : this.buffer.entrySet()) {
            byte[] tmp = entry.getValue();
            if ((tmp[index] & 0xFF & 1 << offset) == 0) continue;
            result = entry.getKey();
        }
        --this.currentCount;
        return result;
    }

    private void getLengthAndNumber(ByteBuffer buffer) {
        this.length = ReadWriteForEncodingUtils.readUnsignedVarInt(buffer);
        this.number = ReadWriteForEncodingUtils.readUnsignedVarInt(buffer);
        byte[] tmp = new byte[this.length];
        buffer.get(tmp, 0, this.length);
        this.byteCache = ByteBuffer.wrap(tmp);
    }

    private void readNext() {
        int len = (this.number + 7) / 8;
        while (this.byteCache.remaining() > 0) {
            int value = ReadWriteForEncodingUtils.readUnsignedVarInt(this.byteCache);
            byte[] tmp = new byte[len];
            this.byteCache.get(tmp, 0, len);
            this.buffer.put(value, tmp);
        }
        this.currentCount = this.number;
    }

    @Override
    public void reset() {
        this.length = 0;
        this.number = 0;
        this.currentCount = 0;
        if (this.byteCache == null) {
            this.byteCache = ByteBuffer.allocate(0);
        } else {
            this.byteCache.position(0);
        }
        if (this.buffer == null) {
            this.buffer = new HashMap<Integer, byte[]>();
        } else {
            this.buffer.clear();
        }
    }

    public List<Pair<Integer, byte[]>> decodeAll(int target, List<ByteBuffer> pageList) {
        ArrayList<Pair<Integer, byte[]>> resultList = new ArrayList<Pair<Integer, byte[]>>();
        for (ByteBuffer bufferPage : pageList) {
            this.reset();
            this.getLengthAndNumber(bufferPage);
            int byteArrayLength = (this.number + 7) / 8;
            byte[] tmp = new byte[byteArrayLength];
            while (this.byteCache.remaining() > 0) {
                int value = ReadWriteForEncodingUtils.readUnsignedVarInt(this.byteCache);
                if (value == target) {
                    this.byteCache.get(tmp, 0, byteArrayLength);
                    break;
                }
                this.byteCache.position(this.byteCache.position() + byteArrayLength);
            }
            resultList.add(new Pair<Integer, byte[]>(this.number, tmp));
            logger.debug("tsfile-encoding BitmapDecoder: number {} in current page, byte length {}", (Object)this.number, (Object)byteArrayLength);
        }
        return resultList;
    }

    @Override
    public boolean hasNext(ByteBuffer buffer) {
        return this.currentCount > 0 || buffer.remaining() > 0;
    }

    @Override
    public boolean readBoolean(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readBoolean is not supported by BitmapDecoder");
    }

    @Override
    public short readShort(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readShort is not supported by BitmapDecoder");
    }

    @Override
    public long readLong(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readLong is not supported by BitmapDecoder");
    }

    @Override
    public float readFloat(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readFloat is not supported by BitmapDecoder");
    }

    @Override
    public double readDouble(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readDouble is not supported by BitmapDecoder");
    }

    @Override
    public Binary readBinary(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readBinary is not supported by BitmapDecoder");
    }

    @Override
    public BigDecimal readBigDecimal(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readBigDecimal is not supported by BitmapDecoder");
    }
}

