/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session;

import java.time.ZoneId;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.isession.SessionDataSet;
import org.apache.iotdb.rpc.DeepCopyRpcTransportFactory;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.service.rpc.thrift.IClientRPCService;
import org.apache.iotdb.service.rpc.thrift.TSCloseSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionResp;
import org.apache.iotdb.session.Session;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThriftConnection.class);
    protected final TEndPoint endPoint;
    protected final int thriftDefaultBufferSize;
    protected final int thriftMaxFrameSize;
    protected final int connectionTimeoutInMs;
    protected TTransport transport;
    protected IClientRPCService.Iface client;
    protected long sessionId;
    protected long statementId;
    private ZoneId zoneId;

    public ThriftConnection(TEndPoint endPoint, int thriftDefaultBufferSize, int thriftMaxFrameSize, int connectionTimeoutInMs) {
        this.endPoint = endPoint;
        this.thriftDefaultBufferSize = thriftDefaultBufferSize;
        this.thriftMaxFrameSize = thriftMaxFrameSize;
        this.connectionTimeoutInMs = connectionTimeoutInMs;
    }

    public void init(boolean useSSL, String trustStore, String trustStorePwd, String username, String password, boolean enableRPCCompression, ZoneId zoneId, String version) throws IoTDBConnectionException {
        DeepCopyRpcTransportFactory.setDefaultBufferCapacity((int)this.thriftDefaultBufferSize);
        DeepCopyRpcTransportFactory.setThriftMaxFrameSize((int)this.thriftMaxFrameSize);
        try {
            this.transport = useSSL ? DeepCopyRpcTransportFactory.INSTANCE.getTransport(this.endPoint.getIp(), this.endPoint.getPort(), this.connectionTimeoutInMs, trustStore, trustStorePwd) : DeepCopyRpcTransportFactory.INSTANCE.getTransport(this.endPoint.getIp(), this.endPoint.getPort(), this.connectionTimeoutInMs);
            if (!this.transport.isOpen()) {
                this.transport.open();
            }
            this.zoneId = zoneId;
        }
        catch (TTransportException e) {
            throw new IoTDBConnectionException((Throwable)e);
        }
        this.client = enableRPCCompression ? new IClientRPCService.Client((TProtocol)new TCompactProtocol(this.transport)) : new IClientRPCService.Client((TProtocol)new TBinaryProtocol(this.transport));
        this.client = RpcUtils.newSynchronizedClient((IClientRPCService.Iface)this.client);
        TSOpenSessionReq openReq = new TSOpenSessionReq();
        openReq.setUsername(username);
        openReq.setPassword(password);
        openReq.setZoneId(zoneId.toString());
        openReq.putToConfiguration("version", version);
        try {
            TSOpenSessionResp openResp = this.client.openSession(openReq);
            RpcUtils.verifySuccess((TSStatus)openResp.getStatus());
            if (Session.protocolVersion.getValue() != openResp.getServerProtocolVersion().getValue()) {
                LOGGER.warn("Protocol differ, Client version is {}}, but Server version is {}", (Object)Session.protocolVersion.getValue(), (Object)openResp.getServerProtocolVersion().getValue());
                if (openResp.getServerProtocolVersion().getValue() == 0) {
                    throw new TException(String.format("Protocol not supported, Client version is %s, but Server version is %s", Session.protocolVersion.getValue(), openResp.getServerProtocolVersion().getValue()));
                }
            }
            this.sessionId = openResp.getSessionId();
            this.statementId = this.client.requestStatementId(this.sessionId);
        }
        catch (Exception e) {
            this.transport.close();
            throw new IoTDBConnectionException((Throwable)e);
        }
    }

    protected SessionDataSet executeQueryStatement(String sql, long timeout, int fetchSize) throws StatementExecutionException, IoTDBConnectionException {
        TSExecuteStatementResp execResp;
        TSExecuteStatementReq execReq = new TSExecuteStatementReq(this.sessionId, sql, this.statementId);
        execReq.setFetchSize(fetchSize);
        execReq.setTimeout(timeout);
        try {
            execResp = this.client.executeQueryStatementV2(execReq);
        }
        catch (TException e) {
            throw new IoTDBConnectionException((Throwable)e);
        }
        RpcUtils.verifySuccess((TSStatus)execResp.getStatus());
        return new SessionDataSet(sql, execResp.getColumns(), execResp.getDataTypeList(), execResp.columnNameIndexMap, execResp.getQueryId(), this.statementId, this.client, this.sessionId, execResp.queryResult, execResp.isIgnoreTimeStamp(), timeout, execResp.moreData, fetchSize, this.zoneId);
    }

    public void close() {
        block4: {
            if (this.transport != null && this.transport.isOpen()) {
                try {
                    if (this.client != null) {
                        this.client.closeSession(new TSCloseSessionReq(this.sessionId));
                    }
                }
                catch (TException e) {
                    LOGGER.warn("Closing Session-{} with {} failed.", (Object)this.sessionId, (Object)this.endPoint);
                    if (!this.transport.isOpen()) break block4;
                    this.transport.close();
                }
            }
        }
    }
}

