/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.approximate;

import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.approximate.ApproxMostFrequentBucketDeserializer;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.approximate.ApproxMostFrequentBucketSerializer;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.approximate.Counter;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.approximate.ListNode2;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.approximate.SpaceSavingByteCalculator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.approximate.StreamSummary;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class SpaceSaving<K> {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(SpaceSaving.class);
    private static final long STREAM_SUMMARY_SIZE = RamUsageEstimator.shallowSizeOfInstance(StreamSummary.class);
    private static final long LIST_NODE2_SIZE = RamUsageEstimator.shallowSizeOfInstance(ListNode2.class);
    private static final long COUNTER_SIZE = RamUsageEstimator.shallowSizeOfInstance(Counter.class);
    private StreamSummary<K> streamSummary;
    private final int maxBuckets;
    private final int capacity;
    private final ApproxMostFrequentBucketSerializer<K> serializer;
    private final ApproxMostFrequentBucketDeserializer<K> deserializer;
    private final SpaceSavingByteCalculator<K> calculator;

    public SpaceSaving(int maxBuckets, int capacity, ApproxMostFrequentBucketSerializer<K> serializer, ApproxMostFrequentBucketDeserializer<K> deserializer, SpaceSavingByteCalculator<K> calculator) {
        this.streamSummary = new StreamSummary(capacity);
        this.maxBuckets = maxBuckets;
        this.capacity = capacity;
        this.serializer = serializer;
        this.deserializer = deserializer;
        this.calculator = calculator;
    }

    public SpaceSaving(byte[] bytes, ApproxMostFrequentBucketSerializer<K> serializer, ApproxMostFrequentBucketDeserializer<K> deserializer, SpaceSavingByteCalculator<K> calculator) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        this.maxBuckets = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        this.capacity = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        int counterSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        this.streamSummary = new StreamSummary(this.capacity);
        this.serializer = serializer;
        this.deserializer = deserializer;
        this.calculator = calculator;
        for (int i = 0; i < counterSize; ++i) {
            this.deserializer.deserialize(byteBuffer, this);
        }
    }

    public static long getDefaultEstimatedSize() {
        return INSTANCE_SIZE + STREAM_SUMMARY_SIZE + 50L * (LIST_NODE2_SIZE + COUNTER_SIZE + 8L);
    }

    public long getEstimatedSize() {
        return INSTANCE_SIZE + STREAM_SUMMARY_SIZE + (long)this.streamSummary.size() * (LIST_NODE2_SIZE + COUNTER_SIZE + 8L);
    }

    public void add(K key) {
        this.streamSummary.offer(key);
    }

    public void add(K key, long incrementCount) {
        this.streamSummary.offer(key, Math.toIntExact(incrementCount));
    }

    public void merge(SpaceSaving<K> other) {
        List<Counter<K>> counters = other.streamSummary.topK(this.capacity);
        for (Counter<K> counter : counters) {
            this.streamSummary.offer(counter.getItem(), Math.toIntExact(counter.getCount()));
        }
    }

    public void forEachBucket(BucketConsumer<K> consumer) {
        List<Counter<K>> counters = this.streamSummary.topK(this.maxBuckets);
        for (Counter<K> counter : counters) {
            consumer.process(counter.getItem(), counter.getCount());
        }
    }

    public Map<K, Long> getBuckets() {
        ImmutableMap.Builder buckets = ImmutableMap.builder();
        this.forEachBucket((arg_0, arg_1) -> ((ImmutableMap.Builder)buckets).put(arg_0, arg_1));
        return buckets.buildOrThrow();
    }

    public byte[] serialize() {
        List<Counter<K>> counters = this.streamSummary.topK(this.capacity);
        int keyBytesSize = this.calculator.calculateBytes(counters);
        int estimatedTotalBytes = 12 + keyBytesSize + counters.size() * 16;
        ByteBuffer byteBuffer = ByteBuffer.allocate(estimatedTotalBytes);
        ReadWriteIOUtils.write((int)this.maxBuckets, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.capacity, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)counters.size(), (ByteBuffer)byteBuffer);
        for (Counter<K> counter : counters) {
            this.serializer.serialize(counter.getItem(), counter.getCount(), byteBuffer);
        }
        return byteBuffer.array();
    }

    public void reset() {
        this.streamSummary = new StreamSummary(this.capacity);
    }

    public static interface BucketConsumer<K> {
        public void process(K var1, long var2);
    }
}

