/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.write;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.TableDeviceSchemaCache;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.IWALByteBufferView;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.schema.MeasurementSchema;

public class RelationalInsertRowNode
extends InsertRowNode {
    public RelationalInsertRowNode(PlanNodeId id, PartialPath devicePath, boolean isAligned, String[] measurements, TSDataType[] dataTypes, long time, Object[] values, boolean isNeedInferType, TsTableColumnCategory[] columnCategories) {
        super(id, devicePath, isAligned, measurements, dataTypes, time, values, isNeedInferType);
        this.setColumnCategories(columnCategories);
    }

    public RelationalInsertRowNode(PlanNodeId id) {
        super(id);
    }

    public RelationalInsertRowNode(PlanNodeId id, PartialPath devicePath, boolean isAligned, String[] measurements, TSDataType[] dataTypes, MeasurementSchema[] measurementSchemas, long time, Object[] values, boolean isNeedInferType, TsTableColumnCategory[] columnCategories) {
        super(id, devicePath, isAligned, measurements, dataTypes, measurementSchemas, time, values, isNeedInferType);
        this.setColumnCategories(columnCategories);
    }

    @Override
    public IDeviceID getDeviceID() {
        if (this.deviceID == null) {
            String[] deviceIdSegments = new String[this.idColumnIndices.size() + 1];
            deviceIdSegments[0] = this.getTableName();
            for (int i = 0; i < this.idColumnIndices.size(); ++i) {
                Integer columnIndex = (Integer)this.idColumnIndices.get(i);
                deviceIdSegments[i + 1] = this.getValues()[columnIndex] != null ? this.getValues()[columnIndex].toString() : null;
            }
            this.deviceID = IDeviceID.Factory.DEFAULT_FACTORY.create(deviceIdSegments);
        }
        return this.deviceID;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitRelationalInsertRow(this, context);
    }

    public static RelationalInsertRowNode deserialize(ByteBuffer byteBuffer) {
        RelationalInsertRowNode insertNode = new RelationalInsertRowNode(new PlanNodeId(""));
        insertNode.subDeserialize(byteBuffer);
        insertNode.setPlanNodeId(PlanNodeId.deserialize(byteBuffer));
        return insertNode;
    }

    public static RelationalInsertRowNode deserializeFromWAL(DataInputStream stream) throws IOException {
        long searchIndex = stream.readLong();
        RelationalInsertRowNode insertNode = RelationalInsertRowNode.subDeserializeFromWAL(stream);
        insertNode.setSearchIndex(searchIndex);
        return insertNode;
    }

    public static RelationalInsertRowNode deserializeFromWAL(ByteBuffer buffer) {
        long searchIndex = buffer.getLong();
        RelationalInsertRowNode insertNode = RelationalInsertRowNode.subDeserializeFromWAL(buffer);
        insertNode.setSearchIndex(searchIndex);
        return insertNode;
    }

    protected static RelationalInsertRowNode subDeserializeFromWAL(DataInputStream stream) throws IOException {
        RelationalInsertRowNode insertNode = new RelationalInsertRowNode(new PlanNodeId(""));
        insertNode.setTime(stream.readLong());
        try {
            insertNode.setTargetPath(insertNode.readTargetPath(stream));
        }
        catch (IllegalPathException e) {
            throw new IllegalArgumentException("Cannot deserialize InsertRowNode", e);
        }
        insertNode.deserializeMeasurementsAndValuesFromWAL(stream);
        TsTableColumnCategory[] newColumnCategories = new TsTableColumnCategory[insertNode.dataTypes.length];
        for (int i = 0; i < insertNode.dataTypes.length; ++i) {
            newColumnCategories[i] = TsTableColumnCategory.deserialize((InputStream)stream);
        }
        insertNode.setColumnCategories(newColumnCategories);
        return insertNode;
    }

    protected static RelationalInsertRowNode subDeserializeFromWAL(ByteBuffer buffer) {
        RelationalInsertRowNode insertNode = new RelationalInsertRowNode(new PlanNodeId(""));
        insertNode.setTime(buffer.getLong());
        try {
            insertNode.setTargetPath(insertNode.readTargetPath(buffer));
        }
        catch (IllegalPathException e) {
            throw new IllegalArgumentException("Cannot deserialize InsertRowNode", e);
        }
        insertNode.deserializeMeasurementsAndValuesFromWAL(buffer);
        TsTableColumnCategory[] newColumnCategories = new TsTableColumnCategory[insertNode.dataTypes.length];
        for (int i = 0; i < insertNode.dataTypes.length; ++i) {
            newColumnCategories[i] = TsTableColumnCategory.deserialize((ByteBuffer)buffer);
        }
        insertNode.setColumnCategories(newColumnCategories);
        return insertNode;
    }

    @Override
    void subSerialize(ByteBuffer buffer) {
        super.subSerialize(buffer);
        for (int i = 0; i < this.measurements.length; ++i) {
            if (this.measurements[i] == null) continue;
            this.columnCategories[i].serialize(buffer);
        }
    }

    @Override
    void subSerialize(DataOutputStream stream) throws IOException {
        super.subSerialize(stream);
        for (int i = 0; i < this.measurements.length; ++i) {
            if (this.measurements[i] == null) continue;
            this.columnCategories[i].serialize((OutputStream)stream);
        }
    }

    @Override
    protected void subSerialize(IWALByteBufferView buffer) {
        super.subSerialize(buffer);
        for (int i = 0; i < this.measurements.length; ++i) {
            if (this.measurements[i] == null) continue;
            buffer.put(this.columnCategories[i].getCategory());
        }
    }

    @Override
    public void subDeserialize(ByteBuffer buffer) {
        super.subDeserialize(buffer);
        TsTableColumnCategory[] newColumnCategories = new TsTableColumnCategory[this.measurements.length];
        for (int i = 0; i < this.measurements.length; ++i) {
            newColumnCategories[i] = TsTableColumnCategory.deserialize((ByteBuffer)buffer);
        }
        this.setColumnCategories(newColumnCategories);
    }

    @Override
    protected int subSerializeSize() {
        return super.subSerializeSize() + this.columnCategories.length * 1;
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.RELATIONAL_INSERT_ROW;
    }

    @Override
    public String getTableName() {
        return this.targetPath.getFullPath();
    }

    @Override
    protected PartialPath readTargetPath(ByteBuffer buffer) throws IllegalPathException {
        return new PartialPath(ReadWriteIOUtils.readString((ByteBuffer)buffer), false);
    }

    @Override
    protected PartialPath readTargetPath(DataInputStream stream) throws IllegalPathException, IOException {
        return new PartialPath(ReadWriteIOUtils.readString((InputStream)stream), false);
    }

    @Override
    public void updateLastCache(String databaseName) {
        String[] rawMeasurements = this.getRawMeasurements();
        TimeValuePair[] timeValuePairs = new TimeValuePair[rawMeasurements.length];
        for (int i = 0; i < rawMeasurements.length; ++i) {
            timeValuePairs[i] = this.composeTimeValuePair(i);
        }
        TableDeviceSchemaCache.getInstance().updateLastCacheIfExists(databaseName, this.getDeviceID(), rawMeasurements, timeValuePairs);
    }
}

