/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.columngenerator;

import java.util.Optional;
import org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator.ITimeRangeIterator;
import org.apache.iotdb.db.utils.columngenerator.ColumnGenerator;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.block.column.LongColumn;

public class SlidingTimeColumnGenerator
extends ColumnGenerator {
    private final ITimeRangeIterator timeRangeIterator;

    public SlidingTimeColumnGenerator(ITimeRangeIterator timeRangeIterator) {
        this.timeRangeIterator = timeRangeIterator;
    }

    @Override
    public Column[] generate(int positionCount) {
        long[] values = new long[positionCount];
        int index = 0;
        while (index < positionCount && this.timeRangeIterator.hasNextTimeRange()) {
            values[index++] = this.timeRangeIterator.nextTimeRange().getMax();
        }
        return new Column[]{new LongColumn(positionCount, Optional.empty(), values)};
    }
}

