/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile;

import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.math3.analysis.interpolation.AkimaSplineInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFSpline
implements UDTF {
    AkimaSplineInterpolator asi;
    int samplePoints;
    ArrayList<Long> timestamp = new ArrayList();
    ArrayList<Double> yDouble = new ArrayList();
    ArrayList<Double> xDouble = new ArrayList();
    Long minimumTimestamp = -1L;
    PolynomialSplineFunction psf;

    @Override
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, Type.FLOAT, Type.DOUBLE, Type.INT32, Type.INT64);
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy(new RowByRowAccessStrategy()).setOutputDataType(Type.DOUBLE);
        this.samplePoints = parameters.getInt("points");
        this.timestamp.clear();
        this.xDouble.clear();
        this.yDouble.clear();
    }

    @Override
    public void transform(Row row, PointCollector collector) throws Exception {
        double v = Util.getValueAsDouble(row);
        if (Double.isFinite(v)) {
            Long t2 = row.getTime();
            if (this.minimumTimestamp < 0L) {
                this.minimumTimestamp = t2;
            }
            this.timestamp.add(t2);
            this.xDouble.add(Double.valueOf(Long.toString(t2 - this.minimumTimestamp)));
            this.yDouble.add(Util.getValueAsDouble(row));
        }
    }

    @Override
    public void terminate(PointCollector collector) throws Exception {
        if (this.yDouble.size() >= 4 && this.samplePoints >= 2) {
            this.asi = new AkimaSplineInterpolator();
            double[] x = ArrayUtils.toPrimitive(this.xDouble.toArray(new Double[0]));
            double[] y = ArrayUtils.toPrimitive(this.yDouble.toArray(new Double[0]));
            this.psf = this.asi.interpolate(x, y);
            for (int i = 0; i < this.samplePoints; ++i) {
                int approximation = (int)Math.floor((x[0] * (double)(this.samplePoints - 1 - i) + x[this.yDouble.size() - 1] * (double)i) / (double)(this.samplePoints - 1) + 0.5);
                double yhead = this.psf.value(approximation);
                collector.putDouble(this.minimumTimestamp + (long)approximation, yhead);
            }
        }
    }
}

