/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jackrabbit.ocm.manager.beanconverter;

import java.util.ArrayList;
import java.util.List;

import javax.jcr.Node;
import javax.jcr.Session;

import org.apache.jackrabbit.ocm.exception.JcrMappingException;
import org.apache.jackrabbit.ocm.exception.ObjectContentManagerException;
import org.apache.jackrabbit.ocm.exception.RepositoryException;
import org.apache.jackrabbit.ocm.manager.atomictypeconverter.AtomicTypeConverterProvider;
import org.apache.jackrabbit.ocm.manager.beanconverter.impl.AbstractBeanConverterImpl;
import org.apache.jackrabbit.ocm.manager.objectconverter.ObjectConverter;
import org.apache.jackrabbit.ocm.mapper.Mapper;
import org.apache.jackrabbit.ocm.mapper.model.BeanDescriptor;
import org.apache.jackrabbit.ocm.mapper.model.ClassDescriptor;
import org.apache.jackrabbit.ocm.testmodel.B;

public class FakeBeanConverter extends AbstractBeanConverterImpl implements BeanConverter {

    private static List log = new ArrayList();

    public FakeBeanConverter(Mapper mapper, ObjectConverter objectConverter, AtomicTypeConverterProvider atomicTypeConverterProvider) {
        super(mapper, objectConverter, atomicTypeConverterProvider);


    }

    public static void cleanUpLog() {
        log.clear();
    }

    public static List getLog() {
        return log;
    }

    public void insert(Session session, Node parentNode, BeanDescriptor beanDescriptor, ClassDescriptor beanClassDescriptor, Object object, ClassDescriptor parentClassDescriptor, Object parent)
            throws ObjectContentManagerException, RepositoryException, JcrMappingException {
        try {
            log.add("insert at path " + parentNode.getPath());

        } catch (javax.jcr.RepositoryException re) {
            throw new ObjectContentManagerException(re);
        }
    }

	public void update(Session session, Node parentNode, BeanDescriptor beanDescriptor, ClassDescriptor beanClassDescriptor, Object object, ClassDescriptor parentClassDescriptor, Object parent)
	throws ObjectContentManagerException, RepositoryException,	JcrMappingException {
        try {
            log.add("update at path " + parentNode.getPath());
        }
        catch(javax.jcr.RepositoryException re) {
            throw new ObjectContentManagerException(re);
        }

    }

    public Object getObject(Session session, Node parentNode, BeanDescriptor beanDescriptor, ClassDescriptor beanClassDescriptor, Class beanClass, Object parent)
            throws ObjectContentManagerException, RepositoryException, JcrMappingException {
        try {
            log.add("get from path " + parentNode.getPath());
        } catch (javax.jcr.RepositoryException re) {
            throw new ObjectContentManagerException(re);
        }
        // The B object is not important for the unit test.
        // The unit test checks only the log generated by this converter
        return new B();
    }

    public void remove(Session session, Node parentNode, BeanDescriptor beanDescriptor, ClassDescriptor beanClassDescriptor, Object object, ClassDescriptor parentClassDescriptor, Object parent)
            throws ObjectContentManagerException, RepositoryException, JcrMappingException {

        try {
            log.add("remove from path " + parentNode.getPath());
        } catch (javax.jcr.RepositoryException re) {
            throw new ObjectContentManagerException(re);
        }
    }
}
