/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jackrabbit.ocm.testmodel.auto.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.jackrabbit.ocm.manager.collectionconverter.impl.NTCollectionConverterImpl;
import org.apache.jackrabbit.ocm.mapper.impl.annotation.Collection;
import org.apache.jackrabbit.ocm.mapper.impl.annotation.Implement;
import org.apache.jackrabbit.ocm.mapper.impl.annotation.Node;
import org.apache.jackrabbit.ocm.testmodel.auto.CmsObject;
import org.apache.jackrabbit.ocm.testmodel.auto.Folder;

/**
 * Forlder implementation
 *
 * @author <a href="mailto:christophe.lombart@gmail.com">Christophe Lombart</a>
 *
 */
@Node(jcrType="ocm:folderimpl", extend=CmsObjectImpl.class ,discriminator=false)
@Implement(interfaceName=Folder.class)
public class FolderImpl extends CmsObjectImpl implements Folder
{
    @Collection(proxy=true, autoUpdate=false, autoInsert=false, autoRetrieve=false,
    		    elementClassName=CmsObjectImpl.class,
    			collectionConverter=NTCollectionConverterImpl.class)
    protected List children = new ArrayList();

	/**
	 *
	 * @see org.apache.jackrabbit.ocm.testmodel.interfaces.Folder#getChildren()
	 */
	public List getChildren() {
		return children;
	}

	/**
	 *
	 * @see org.apache.jackrabbit.ocm.testmodel.interfaces.Folder#setChildren(java.util.List)
	 */
	public void setChildren(List children) {
		this.children = children;
	}

    /**
     *
     * @see org.apache.jackrabbit.ocm.testmodel.interfaces.Folder#addChild(org.apache.jackrabbit.ocm.testmodel.interfaces.CmsObject)
     */
    public void addChild(CmsObject child)
    {
    	    children.add(child);
    }
}

