/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.mail.MessagingException;
import org.apache.james.transport.InitJCE;
import org.apache.james.transport.SMIMESignerInfo;
import org.apache.james.util.io.UnsynchronizedBufferedInputStream;
import org.bouncycastle.cert.jcajce.JcaCertStoreBuilder;
import org.bouncycastle.cert.selector.X509CertificateHolderSelector;
import org.bouncycastle.cert.selector.jcajce.JcaX509CertSelectorConverter;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.mail.smime.SMIMESigned;

public class KeyStoreHolder {
    private static final String BC = "BC";
    protected KeyStore keyStore;

    public KeyStoreHolder() throws IOException, GeneralSecurityException {
        this("changeit");
    }

    public KeyStoreHolder(String password) throws IOException, GeneralSecurityException {
        this(System.getProperty("java.home") + "/lib/security/cacerts".replace('/', File.separatorChar), password, KeyStore.getDefaultType());
    }

    public KeyStoreHolder(String keyStoreFileName, String keyStorePassword, String keyStoreType) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, NoSuchProviderException, IOException {
        if (keyStorePassword == null) {
            keyStorePassword = "";
        }
        try {
            InitJCE.init();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            NoSuchProviderException ex = new NoSuchProviderException("Error during cryptography provider initialization. Has bcprov-jdkxx-yyy.jar been copied in the lib directory or installed in the system?");
            ex.initCause(e);
            throw ex;
        }
        if (keyStoreType == null) {
            keyStoreType = KeyStore.getDefaultType();
        }
        this.keyStore = KeyStore.getInstance(keyStoreType);
        this.keyStore.load((InputStream)new UnsynchronizedBufferedInputStream((InputStream)new FileInputStream(keyStoreFileName)), keyStorePassword.toCharArray());
        if (this.keyStore.size() == 0) {
            throw new KeyStoreException("The keystore must be not empty");
        }
    }

    public List<SMIMESignerInfo> verifySignatures(SMIMESigned signed) throws Exception {
        CertStore certs = new JcaCertStoreBuilder().addCertificates(signed.getCertificates()).addCRLs(signed.getCRLs()).build();
        SignerInformationStore siginfo = signed.getSignerInfos();
        Collection sigCol = siginfo.getSigners();
        ArrayList<SMIMESignerInfo> result = new ArrayList<SMIMESignerInfo>(sigCol.size());
        for (SignerInformation info : sigCol) {
            X509CertificateHolderSelector x509CertificateHolderSelector = new X509CertificateHolderSelector(info.getSID().getSubjectKeyIdentifier());
            X509CertSelector certSelector = new JcaX509CertSelectorConverter().getCertSelector(x509CertificateHolderSelector);
            Collection<? extends Certificate> certCollection = certs.getCertificates(certSelector);
            if (certCollection.isEmpty()) continue;
            X509Certificate signerCert = (X509Certificate)certCollection.iterator().next();
            CertPath path = KeyStoreHolder.verifyCertificate(signerCert, certs, this.keyStore);
            try {
                if (!info.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(signerCert))) continue;
                result.add(new SMIMESignerInfo(signerCert, path, true));
            }
            catch (Exception e) {
                result.add(new SMIMESignerInfo(signerCert, path, false));
            }
        }
        return result;
    }

    private static CertPath verifyCertificate(X509Certificate cert, CertStore store, KeyStore trustedStore) throws InvalidAlgorithmParameterException, KeyStoreException, MessagingException, CertPathBuilderException {
        CertPathBuilder pathBuilder;
        Preconditions.checkNotNull((Object)cert);
        Preconditions.checkNotNull((Object)store);
        Preconditions.checkNotNull((Object)trustedStore);
        try {
            pathBuilder = CertPathBuilder.getInstance("PKIX", BC);
        }
        catch (Exception e) {
            throw new MessagingException("Error during the creation of the certpathbuilder.", e);
        }
        X509CertSelector xcs = new X509CertSelector();
        xcs.setCertificate(cert);
        PKIXBuilderParameters params = new PKIXBuilderParameters(trustedStore, (CertSelector)xcs);
        params.addCertStore(store);
        params.setRevocationEnabled(false);
        try {
            CertPathBuilderResult result = pathBuilder.build(params);
            return result.getCertPath();
        }
        catch (CertPathBuilderException e) {
            return null;
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new MessagingException("Error during the certification path search.", (Exception)e);
        }
    }
}

