/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.parser.AbstractContentHandler;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.parser.MimeStreamParser;
import org.apache.james.mime4j.stream.BodyDescriptor;
import org.junit.Assert;
import org.junit.Test;

public class ExtractPartWithDifferentLengthsTest {
    @Test
    public void testExtractPartWithDifferentLengths() throws Exception {
        StringBuilder partBuilder = new StringBuilder();
        for (int i = 1; i <= 5000; ++i) {
            partBuilder.append(i % 80 == 0 ? "\n" : "A");
            String part = partBuilder.toString();
            String mimeMessage = this.createMimeMultipart(part);
            String extracted = this.extractPart(mimeMessage);
            Assert.assertEquals((Object)part, (Object)extracted);
        }
    }

    private String createMimeMultipart(String part) {
        return "Content-type: multipart/mixed; boundary=QvEgqhjEnYxz\n\n--QvEgqhjEnYxz\nContent-Type: text/plain\n\n" + part + "\r\n--QvEgqhjEnYxz--\n";
    }

    private String extractPart(String mimeMessage) throws MimeException, IOException {
        final String[] resultWrapper = new String[1];
        MimeStreamParser parser = new MimeStreamParser();
        parser.setContentHandler((ContentHandler)new AbstractContentHandler(){

            public void body(BodyDescriptor bd, InputStream is) throws IOException {
                resultWrapper[0] = new String(IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8).getBytes());
            }
        });
        parser.parse((InputStream)new ByteArrayInputStream(mimeMessage.getBytes()));
        return resultWrapper[0];
    }
}

