/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.quota.search.elasticsearch.v7;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.james.backends.es.v7.AliasName;
import org.apache.james.backends.es.v7.ReactorElasticSearchClient;
import org.apache.james.backends.es.v7.ReadAliasName;
import org.apache.james.backends.es.v7.search.ScrolledSearch;
import org.apache.james.core.Username;
import org.apache.james.quota.search.QuotaQuery;
import org.apache.james.quota.search.QuotaSearcher;
import org.apache.james.quota.search.elasticsearch.v7.QuotaQueryConverter;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import reactor.core.publisher.Flux;

public class ElasticSearchQuotaSearcher
implements QuotaSearcher {
    private static final TimeValue TIMEOUT = TimeValue.timeValueMinutes((long)1L);
    private final ReactorElasticSearchClient client;
    private final AliasName readAlias;
    private final QuotaQueryConverter quotaQueryConverter;

    public ElasticSearchQuotaSearcher(ReactorElasticSearchClient client, ReadAliasName readAlias) {
        this.client = client;
        this.readAlias = readAlias;
        this.quotaQueryConverter = new QuotaQueryConverter();
    }

    public List<Username> search(QuotaQuery query) {
        try {
            return (List)this.searchHits(query).map(SearchHit::getId).map(Username::of).collect(ImmutableList.toImmutableList()).block();
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception while executing " + query, e);
        }
    }

    private Flux<SearchHit> searchHits(QuotaQuery query) {
        if (query.getLimit().isLimited()) {
            return this.executeSingleSearch(query);
        }
        return this.executeScrolledSearch(query);
    }

    private Flux<SearchHit> executeSingleSearch(QuotaQuery query) {
        SearchSourceBuilder searchSourceBuilder = this.searchSourceBuilder(query).from(query.getOffset().getValue());
        query.getLimit().getValue().ifPresent(arg_0 -> ((SearchSourceBuilder)searchSourceBuilder).size(arg_0));
        SearchRequest searchRequest = new SearchRequest(new String[]{this.readAlias.getValue()}).source(searchSourceBuilder);
        return this.client.search(searchRequest, RequestOptions.DEFAULT).flatMapIterable(searchResponse -> ImmutableList.copyOf((Object[])searchResponse.getHits().getHits()));
    }

    private Flux<SearchHit> executeScrolledSearch(QuotaQuery query) {
        return new ScrolledSearch(this.client, new SearchRequest(new String[]{this.readAlias.getValue()}).source(this.searchSourceBuilder(query)).scroll(TIMEOUT)).searchHits().skip((long)query.getOffset().getValue());
    }

    private SearchSourceBuilder searchSourceBuilder(QuotaQuery query) {
        return new SearchSourceBuilder().query(this.quotaQueryConverter.from(query)).sort(SortBuilders.fieldSort((String)"user").order(SortOrder.ASC));
    }
}

