/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.core.configuration;

import com.google.common.base.MoreObjects;
import java.io.File;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.filesystem.api.JamesDirectoriesProvider;
import org.apache.james.server.core.JamesServerResourceLoader;
import org.apache.james.server.core.MissingArgumentException;

public interface Configuration {
    public static final String WORKING_DIRECTORY = "working.directory";

    public static Basic.Builder builder() {
        return new Basic.Builder();
    }

    public ConfigurationPath configurationPath();

    public JamesDirectoriesProvider directories();

    public static class Basic
    implements Configuration {
        private final ConfigurationPath configurationPath;
        private final JamesDirectoriesProvider directories;

        public static Builder builder() {
            return new Builder();
        }

        public Basic(ConfigurationPath configurationPath, JamesDirectoriesProvider directories) {
            this.configurationPath = configurationPath;
            this.directories = directories;
        }

        @Override
        public ConfigurationPath configurationPath() {
            return this.configurationPath;
        }

        @Override
        public JamesDirectoriesProvider directories() {
            return this.directories;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("configurationPath", (Object)this.configurationPath).add("directories", (Object)this.directories).toString();
        }

        public static class Builder {
            private Optional<String> rootDirectory = Optional.empty();
            private Optional<ConfigurationPath> configurationPath = Optional.empty();

            private Builder() {
            }

            public Builder workingDirectory(String path) {
                this.rootDirectory = Optional.of(path);
                return this;
            }

            public Builder workingDirectory(File file) {
                this.rootDirectory = Optional.of(file.getAbsolutePath());
                return this;
            }

            public Builder useWorkingDirectoryEnvProperty() {
                this.rootDirectory = Optional.ofNullable(System.getProperty(Configuration.WORKING_DIRECTORY));
                if (!this.rootDirectory.isPresent()) {
                    throw new MissingArgumentException("Server needs a working.directory env entry");
                }
                return this;
            }

            public Builder configurationPath(ConfigurationPath path) {
                this.configurationPath = Optional.of(path);
                return this;
            }

            public Builder configurationFromClasspath() {
                this.configurationPath = Optional.of(new ConfigurationPath("classpath:"));
                return this;
            }

            public Basic build() {
                ConfigurationPath configurationPath = this.configurationPath.orElse(new ConfigurationPath("file://conf/"));
                JamesServerResourceLoader directories = new JamesServerResourceLoader(this.rootDirectory.orElseThrow(() -> new MissingArgumentException("Server needs a working.directory env entry")));
                return new Basic(configurationPath, directories);
            }
        }
    }

    public static class ConfigurationPath {
        private final String value;

        public ConfigurationPath(String value) {
            this.value = value;
        }

        public String asString() {
            return this.value;
        }

        public final boolean equals(Object o) {
            if (o instanceof ConfigurationPath) {
                ConfigurationPath that = (ConfigurationPath)o;
                return Objects.equals(this.value, that.value);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
        }
    }
}

