/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.inject.Inject;
import javax.mail.Flags;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Header;
import org.apache.james.mailbox.model.Headers;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MultimailboxesSearchQuery;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.util.streams.Iterators;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReferenceUpdater {
    public static final String X_FORWARDED_ID_HEADER = "X-Forwarded-Message-Id";
    public static final Flags FORWARDED_FLAG = new Flags("$Forwarded");
    private static final Logger logger = LoggerFactory.getLogger(ReferenceUpdater.class);
    private final MessageIdManager messageIdManager;
    private final MailboxManager mailboxManager;

    @Inject
    public ReferenceUpdater(MessageIdManager messageIdManager, MailboxManager mailboxManager) {
        this.messageIdManager = messageIdManager;
        this.mailboxManager = mailboxManager;
    }

    public Mono<Void> updateReferences(Headers headers, MailboxSession session) throws MailboxException {
        Map headersAsMap = (Map)Iterators.toStream((Iterator)headers.headers()).collect(ImmutableMap.toImmutableMap(Header::getName, Header::getValue));
        return this.updateReferences(headersAsMap, session);
    }

    public Mono<Void> updateReferences(Map<String, String> headers, MailboxSession session) throws MailboxException {
        Optional<String> inReplyToId = Optional.ofNullable(headers.get("In-Reply-To"));
        Optional<String> forwardedId = Optional.ofNullable(headers.get(X_FORWARDED_ID_HEADER));
        return inReplyToId.map(Throwing.function(id -> this.updateAnswered((String)id, session)).sneakyThrow()).orElse(Mono.empty()).then(forwardedId.map(Throwing.function(id -> this.updateForwarded((String)id, session)).sneakyThrow()).orElse(Mono.empty()));
    }

    private Mono<Void> updateAnswered(String messageId, MailboxSession session) throws MailboxException {
        return this.updateFlag(messageId, session, new Flags(Flags.Flag.ANSWERED));
    }

    private Mono<Void> updateForwarded(String messageId, MailboxSession session) throws MailboxException {
        return this.updateFlag(messageId, session, FORWARDED_FLAG);
    }

    private Mono<Void> updateFlag(String messageId, MailboxSession session, Flags flag) throws MailboxException {
        int limit = 2;
        MultimailboxesSearchQuery searchByRFC822MessageId = MultimailboxesSearchQuery.from((SearchQuery)SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.mimeMessageID((String)messageId)})).build();
        return Flux.from((Publisher)this.mailboxManager.search(searchByRFC822MessageId, session, (long)limit)).collectList().flatMap(references -> {
            MessageId reference = (MessageId)Iterables.getOnlyElement((Iterable)references);
            return Flux.from((Publisher)this.messageIdManager.messageMetadata(reference, session)).map(metaData -> metaData.getComposedMessageId().getMailboxId()).collect(ImmutableList.toImmutableList()).flatMap(mailboxIds -> Mono.from((Publisher)this.messageIdManager.setFlagsReactive(flag, MessageManager.FlagsUpdateMode.ADD, reference, (List)mailboxIds, session)));
        }).onErrorResume(NoSuchElementException.class, e -> {
            logger.info("Unable to find a message with this Mime Message Id: " + messageId);
            return Mono.empty();
        }).onErrorResume(IllegalArgumentException.class, e -> {
            logger.info("Too many messages are matching this Mime Message Id: " + messageId);
            return Mono.empty();
        });
    }
}

