/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import org.apache.james.imap.api.process.ImapLineHandler;
import org.apache.james.imap.api.process.ImapSession;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;

public class ImapLineHandlerAdapter
extends SimpleChannelUpstreamHandler {
    private final ImapLineHandler lineHandler;
    private final ImapSession session;

    public ImapLineHandlerAdapter(ImapSession session, ImapLineHandler lineHandler) {
        this.lineHandler = lineHandler;
        this.session = session;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        byte[] data;
        ChannelBuffer buf = (ChannelBuffer)e.getMessage();
        if (buf.hasArray()) {
            data = buf.array();
        } else {
            data = new byte[buf.readableBytes()];
            buf.readBytes(data);
        }
        this.lineHandler.onLine(this.session, data);
    }
}

