/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.api.model.User;
import org.apache.james.util.streams.Iterators;
import org.apache.james.webadmin.dto.UserResponse;

public class UserService {
    private final UsersRepository usersRepository;

    @Inject
    public UserService(UsersRepository usersRepository) {
        this.usersRepository = usersRepository;
    }

    public List<UserResponse> getUsers() throws UsersRepositoryException {
        return (List)Optional.ofNullable(this.usersRepository.list()).map(Iterators::toStream).orElse(Stream.of(new Username[0])).map(Username::asString).map(UserResponse::new).collect(ImmutableList.toImmutableList());
    }

    public void removeUser(Username username) throws UsersRepositoryException {
        this.usersRepository.removeUser(username);
    }

    public void upsertUser(Username username, char[] password) throws Exception {
        User user = this.usersRepository.getUserByName(username);
        if (user == null) {
            this.usersRepository.addUser(username, new String(password));
        } else {
            user.setPassword(new String(password));
            this.usersRepository.updateUser(user);
        }
    }

    public boolean verifyUser(Username username, String password) throws UsersRepositoryException {
        return this.usersRepository.test(username, password);
    }

    public boolean userExists(Username username) throws UsersRepositoryException {
        return this.usersRepository.contains(username);
    }

    public void insertUser(Username username, char[] password) throws Exception {
        this.usersRepository.addUser(username, new String(password));
    }
}

