/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.domainlist.cassandra;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.Domain;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.domainlist.lib.AbstractDomainList;

public class CassandraDomainList
extends AbstractDomainList {
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement readAllStatement;
    private final PreparedStatement readStatement;
    private final PreparedStatement insertStatement;
    private final PreparedStatement removeStatement;

    @Inject
    public CassandraDomainList(DNSService dnsService, Session session) {
        super(dnsService);
        this.executor = new CassandraAsyncExecutor(session);
        this.readAllStatement = this.prepareReadAllStatement(session);
        this.readStatement = this.prepareReadStatement(session);
        this.insertStatement = this.prepareInsertStatement(session);
        this.removeStatement = this.prepareRemoveStatement(session);
    }

    private PreparedStatement prepareRemoveStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("domains").ifExists().where(QueryBuilder.eq((String)"domain", (Object)QueryBuilder.bindMarker((String)"domain"))));
    }

    private PreparedStatement prepareInsertStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"domains").ifNotExists().value("domain", (Object)QueryBuilder.bindMarker((String)"domain")));
    }

    private PreparedStatement prepareReadStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"domain"}).from("domains").where(QueryBuilder.eq((String)"domain", (Object)QueryBuilder.bindMarker((String)"domain"))));
    }

    private PreparedStatement prepareReadAllStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"domain"}).from("domains"));
    }

    protected List<Domain> getDomainListInternal() throws DomainListException {
        return (List)this.executor.executeRows((Statement)this.readAllStatement.bind()).map(row -> Domain.of((String)row.getString("domain"))).collectList().block();
    }

    protected boolean containsDomainInternal(Domain domain) throws DomainListException {
        return ((Optional)this.executor.executeSingleRowOptional((Statement)this.readStatement.bind().setString("domain", domain.asString())).block()).isPresent();
    }

    public void addDomain(Domain domain) throws DomainListException {
        boolean executed = (Boolean)this.executor.executeReturnApplied((Statement)this.insertStatement.bind().setString("domain", domain.asString())).block();
        if (!executed) {
            throw new DomainListException(domain.name() + " already exists.");
        }
    }

    public void doRemoveDomain(Domain domain) throws DomainListException {
        boolean executed = (Boolean)this.executor.executeReturnApplied((Statement)this.removeStatement.bind().setString("domain", domain.asString())).block();
        if (!executed) {
            throw new DomainListException(domain.name() + " was not found");
        }
    }
}

