/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security.user.privileges;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.client.security.user.privileges.AbstractIndicesPrivileges;
import org.elasticsearch.client.security.user.privileges.IndicesPrivileges;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;

public class UserIndicesPrivileges
extends AbstractIndicesPrivileges {
    private final Set<AbstractIndicesPrivileges.FieldSecurity> fieldSecurity;
    private final Set<String> query;
    private static final ConstructingObjectParser<UserIndicesPrivileges, Void> PARSER = new ConstructingObjectParser("user_indices_privilege", true, UserIndicesPrivileges::buildObjectFromParserArgs);

    private static UserIndicesPrivileges buildObjectFromParserArgs(Object[] args) {
        return new UserIndicesPrivileges((List)args[0], (List)args[1], (Boolean)args[2], (List)args[3], (List)args[4]);
    }

    public static UserIndicesPrivileges fromXContent(XContentParser parser) throws IOException {
        return (UserIndicesPrivileges)PARSER.parse(parser, null);
    }

    public UserIndicesPrivileges(Collection<String> indices, Collection<String> privileges, boolean allowRestrictedIndices, Collection<AbstractIndicesPrivileges.FieldSecurity> fieldSecurity, Collection<String> query) {
        super(indices, privileges, allowRestrictedIndices);
        this.fieldSecurity = fieldSecurity == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<AbstractIndicesPrivileges.FieldSecurity>(fieldSecurity));
        this.query = query == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(query));
    }

    public Set<AbstractIndicesPrivileges.FieldSecurity> getFieldSecurity() {
        return this.fieldSecurity;
    }

    public Set<String> getQueries() {
        return this.query;
    }

    @Override
    public boolean isUsingDocumentLevelSecurity() {
        return !this.query.isEmpty();
    }

    @Override
    public boolean isUsingFieldLevelSecurity() {
        return this.fieldSecurity.stream().anyMatch(AbstractIndicesPrivileges.FieldSecurity::isUsingFieldLevelSecurity);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserIndicesPrivileges that = (UserIndicesPrivileges)o;
        return Objects.equals(this.indices, that.indices) && Objects.equals(this.privileges, that.privileges) && this.allowRestrictedIndices == that.allowRestrictedIndices && Objects.equals(this.fieldSecurity, that.fieldSecurity) && Objects.equals(this.query, that.query);
    }

    public int hashCode() {
        return Objects.hash(this.indices, this.privileges, this.allowRestrictedIndices, this.fieldSecurity, this.query);
    }

    public String toString() {
        return "UserIndexPrivilege{indices=" + this.indices + ", privileges=" + this.privileges + ", allow_restricted_indices=" + this.allowRestrictedIndices + ", fieldSecurity=" + this.fieldSecurity + ", query=" + this.query + '}';
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), IndicesPrivileges.NAMES);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), IndicesPrivileges.PRIVILEGES);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), IndicesPrivileges.ALLOW_RESTRICTED_INDICES);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), AbstractIndicesPrivileges.FieldSecurity::parse, IndicesPrivileges.FIELD_PERMISSIONS);
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), IndicesPrivileges.QUERY);
    }
}

