/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.data;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.server.core.configuration.ConfigurationProvider;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.cassandra.CassandraRepositoryConfiguration;
import org.apache.james.user.cassandra.CassandraUsersDAO;
import org.apache.james.user.lib.UsersDAO;
import org.apache.james.user.lib.UsersRepositoryImpl;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;

public class CassandraUsersRepositoryModule
extends AbstractModule {
    public void configure() {
        this.bind(CassandraUsersDAO.class).in(Scopes.SINGLETON);
        this.bind(UsersDAO.class).to(CassandraUsersDAO.class);
        this.bind((TypeLiteral)new TypeLiteral<UsersRepositoryImpl<CassandraUsersDAO>>(){}).in(Scopes.SINGLETON);
        this.bind(UsersRepository.class).to((TypeLiteral)new TypeLiteral<UsersRepositoryImpl<CassandraUsersDAO>>(){});
        Multibinder cassandraDataDefinitions = Multibinder.newSetBinder((Binder)this.binder(), CassandraModule.class);
        cassandraDataDefinitions.addBinding().toInstance((Object)org.apache.james.user.cassandra.CassandraUsersRepositoryModule.MODULE);
    }

    @Provides
    @Singleton
    public CassandraRepositoryConfiguration provideConfiguration(ConfigurationProvider configurationProvider) throws ConfigurationException {
        return CassandraRepositoryConfiguration.from((HierarchicalConfiguration)configurationProvider.getConfiguration("usersrepository"));
    }

    @ProvidesIntoSet
    InitializationOperation configureUsersRepository(ConfigurationProvider configurationProvider, UsersRepositoryImpl<CassandraUsersDAO> usersRepository) {
        return InitilizationOperationBuilder.forClass(UsersRepositoryImpl.class).init(() -> usersRepository.configure(configurationProvider.getConfiguration("usersrepository")));
    }
}

