/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.apache.james.jmap.draft.model.Filter;
import org.apache.james.jmap.draft.model.FilterCondition;
import org.apache.james.jmap.draft.model.FilterOperator;
import org.apache.james.util.streams.Iterators;

public class FilterDeserializer
extends StdDeserializer<Filter> {
    public FilterDeserializer() {
        super(Filter.class);
    }

    public Filter deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectMapper mapper = (ObjectMapper)p.getCodec();
        ObjectNode obj = (ObjectNode)mapper.readTree(p);
        return (Filter)mapper.treeToValue((TreeNode)obj, this.detectClass(obj.fields()));
    }

    private Class<? extends Filter> detectClass(Iterator<Map.Entry<String, JsonNode>> elements) {
        Optional<Class> maybeFilterOperator = Iterators.toStream(elements).map(Map.Entry::getKey).filter(name -> name.equals("operator")).findFirst().map(x -> FilterOperator.class);
        return maybeFilterOperator.orElse(FilterCondition.class);
    }
}

