/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.jgroups.PhysicalAddress;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.RouterStub;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

public class RouterStubManager
implements Runnable,
RouterStub.CloseListener {
    protected final ConcurrentMap<RouterStub, Future<?>> futures = new ConcurrentHashMap();
    protected volatile List<RouterStub> stubs;
    protected volatile Set<Target> reconnect_list;
    protected final Protocol owner;
    protected final TimeScheduler timer;
    protected final String cluster_name;
    protected final Address local_addr;
    protected final String logical_name;
    protected final PhysicalAddress phys_addr;
    protected final long interval;
    protected boolean use_nio = true;
    protected Future<?> reconnector_task;
    protected final Log log;

    public RouterStubManager(Protocol owner, String cluster_name, Address local_addr, String logical_name, PhysicalAddress phys_addr, long interval) {
        this.owner = owner;
        this.stubs = new ArrayList<RouterStub>();
        this.reconnect_list = new HashSet<Target>();
        this.log = LogFactory.getLog(owner.getClass());
        this.timer = owner.getTransport().getTimer();
        this.cluster_name = cluster_name;
        this.local_addr = local_addr;
        this.logical_name = logical_name;
        this.phys_addr = phys_addr;
        this.interval = interval;
    }

    public static RouterStubManager emptyGossipClientStubManager(Protocol p) {
        return new RouterStubManager(p, null, null, null, null, 0L);
    }

    public RouterStubManager useNio(boolean flag) {
        this.use_nio = flag;
        return this;
    }

    public void forEach(Consumer action) {
        for (RouterStub stub : this.stubs) {
            if (!stub.isConnected()) continue;
            this.apply(stub, action);
        }
    }

    public void forAny(Consumer action) {
        while (!this.stubs.isEmpty()) {
            RouterStub stub = Util.pickRandomElement(this.stubs);
            if (stub == null || !stub.isConnected()) continue;
            this.apply(stub, action);
            return;
        }
    }

    public RouterStub createAndRegisterStub(IpAddress local, IpAddress router_addr) {
        RouterStub stub = new RouterStub(local, router_addr, this.use_nio, this);
        RouterStub old_stub = this.unregisterStub(router_addr);
        if (old_stub != null) {
            old_stub.destroy();
        }
        this.add(stub);
        return stub;
    }

    public RouterStub unregisterStub(IpAddress router_addr) {
        RouterStub stub = this.find(router_addr);
        if (stub != null) {
            this.remove(stub);
        }
        return stub;
    }

    public void connectStubs() {
        for (RouterStub stub : this.stubs) {
            try {
                if (stub.isConnected()) continue;
                stub.connect(this.cluster_name, this.local_addr, this.logical_name, this.phys_addr);
            }
            catch (Throwable e) {
                this.moveStubToReconnects(stub);
            }
        }
    }

    public void disconnectStubs() {
        this.stopReconnector();
        for (RouterStub stub : this.stubs) {
            try {
                stub.disconnect(this.cluster_name, this.local_addr);
            }
            catch (Throwable throwable) {}
        }
    }

    public void destroyStubs() {
        this.stopReconnector();
        for (RouterStub s : this.stubs) {
            s.destroy();
        }
        this.stubs.clear();
    }

    public String printStubs() {
        return Util.printListWithDelimiter(this.stubs, ", ");
    }

    public String printReconnectList() {
        return Util.printListWithDelimiter(this.reconnect_list, ", ");
    }

    public String print() {
        return String.format("Stubs: %s\nReconnect list: %s", this.printStubs(), this.printReconnectList());
    }

    @Override
    public void run() {
        while (!this.reconnect_list.isEmpty()) {
            Iterator<Target> it = this.reconnect_list.iterator();
            while (it.hasNext()) {
                Target target = it.next();
                if (!this.reconnect(target)) continue;
                it.remove();
            }
        }
    }

    @Override
    public void closed(RouterStub stub) {
        this.moveStubToReconnects(stub);
    }

    protected boolean reconnect(Target target) {
        RouterStub stub = new RouterStub(target.bind_addr, target.router_addr, this.use_nio, this).receiver(target.receiver);
        if (!this.add(stub)) {
            return false;
        }
        try {
            stub.connect(this.cluster_name, this.local_addr, this.logical_name, this.phys_addr);
            this.log.debug("re-established connection to %s successfully for group=%s and address=%s", stub.remote(), this.cluster_name, this.local_addr);
            return true;
        }
        catch (Throwable t) {
            this.remove(stub);
            return false;
        }
    }

    protected void moveStubToReconnects(RouterStub stub) {
        if (stub == null) {
            return;
        }
        this.remove(stub);
        if (this.add(new Target(stub.local(), stub.remote(), stub.receiver()))) {
            this.log.debug("connection to %s closed, trying to re-establish connection", stub.remote());
            this.startReconnector();
        }
    }

    protected boolean add(RouterStub stub) {
        if (stub == null) {
            return false;
        }
        ArrayList<RouterStub> new_stubs = new ArrayList<RouterStub>(this.stubs);
        boolean retval = !new_stubs.contains(stub) && new_stubs.add(stub);
        this.stubs = new_stubs;
        return retval;
    }

    protected boolean add(Target target) {
        if (target == null) {
            return false;
        }
        HashSet<Target> new_set = new HashSet<Target>(this.reconnect_list);
        if (new_set.add(target)) {
            this.reconnect_list = new_set;
            return true;
        }
        return false;
    }

    protected boolean remove(RouterStub stub) {
        if (stub == null) {
            return false;
        }
        stub.destroy();
        ArrayList<RouterStub> new_stubs = new ArrayList<RouterStub>(this.stubs);
        boolean retval = new_stubs.remove(stub);
        this.stubs = new_stubs;
        return retval;
    }

    protected boolean remove(Target target) {
        if (target == null) {
            return false;
        }
        HashSet<Target> new_set = new HashSet<Target>(this.reconnect_list);
        if (new_set.remove(target)) {
            this.reconnect_list = new_set;
            return true;
        }
        return false;
    }

    protected void apply(RouterStub stub, Consumer action) {
        try {
            action.accept(stub);
        }
        catch (Throwable t) {
            this.log.warn("failed invoking stub", t);
        }
    }

    protected RouterStub find(IpAddress router_addr) {
        for (RouterStub stub : this.stubs) {
            IpAddress addr = stub.gossipRouterAddress();
            if (addr == null || !addr.equals(router_addr)) continue;
            return stub;
        }
        return null;
    }

    protected synchronized void startReconnector() {
        if (this.reconnector_task == null || this.reconnector_task.isDone()) {
            this.reconnector_task = this.timer.scheduleWithFixedDelay(this, this.interval, this.interval, TimeUnit.MILLISECONDS);
        }
    }

    protected synchronized void stopReconnector() {
        if (this.reconnector_task != null) {
            this.reconnector_task.cancel(true);
        }
    }

    protected static class Target
    implements Comparator<Target> {
        protected final IpAddress bind_addr;
        protected final IpAddress router_addr;
        protected final RouterStub.StubReceiver receiver;

        public Target(IpAddress bind_addr, IpAddress router_addr, RouterStub.StubReceiver receiver) {
            this.bind_addr = bind_addr;
            this.router_addr = router_addr;
            this.receiver = receiver;
        }

        @Override
        public int compare(Target o1, Target o2) {
            return o1.router_addr.compareTo(o2.router_addr);
        }

        public int hashCode() {
            return this.router_addr.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return this.compare(this, (Target)obj) == 0;
        }

        public String toString() {
            return String.format("%s -> %s", this.bind_addr, this.router_addr);
        }
    }

    public static interface Consumer {
        public void accept(RouterStub var1);
    }
}

