/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.impl.sql.compile.ConstraintDefinitionNode;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.execute.ConstraintInfo;

public final class FKConstraintDefinitionNode
extends ConstraintDefinitionNode {
    TableName refTableName;
    ResultColumnList refRcl;
    SchemaDescriptor refTableSd;
    int refActionDeleteRule;
    int refActionUpdateRule;

    FKConstraintDefinitionNode(TableName tableName, TableName tableName2, ResultColumnList resultColumnList, ResultColumnList resultColumnList2, int[] nArray, ContextManager contextManager) {
        super(tableName, 6, resultColumnList, null, null, null, 2, 5, contextManager);
        this.refRcl = resultColumnList2;
        this.refTableName = tableName2;
        this.refActionDeleteRule = nArray[0];
        this.refActionUpdateRule = nArray[1];
    }

    @Override
    void bind(DDLStatementNode dDLStatementNode, DataDictionary dataDictionary) throws StandardException {
        super.bind(dDLStatementNode, dataDictionary);
        this.refTableSd = this.getSchemaDescriptor(this.refTableName.getSchemaName());
        if (this.refTableSd.isSystemSchema()) {
            throw StandardException.newException("42Y08", new Object[0]);
        }
        if (this.refTableName.equals(dDLStatementNode.getObjectName())) {
            return;
        }
        TableDescriptor tableDescriptor = this.getTableDescriptor(this.refTableName.getTableName(), this.refTableSd);
        if (tableDescriptor == null) {
            throw StandardException.newException("X0Y46.S", this.getConstraintMoniker(), this.refTableName.getTableName());
        }
        this.getCompilerContext().pushCurrentPrivType(this.getPrivType());
        this.getCompilerContext().createDependency(tableDescriptor);
        if (this.refRcl.size() == 0 && tableDescriptor.getPrimaryKey() != null) {
            int[] nArray = tableDescriptor.getPrimaryKey().getReferencedColumns();
            for (int i = 0; i < nArray.length; ++i) {
                ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(nArray[i]);
                columnDescriptor.setTableDescriptor(tableDescriptor);
                if (!this.isPrivilegeCollectionRequired()) continue;
                this.getCompilerContext().addRequiredColumnPriv(columnDescriptor);
            }
        } else {
            for (ResultColumn resultColumn : this.refRcl) {
                ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(resultColumn.getName());
                if (columnDescriptor == null) continue;
                columnDescriptor.setTableDescriptor(tableDescriptor);
                if (!this.isPrivilegeCollectionRequired()) continue;
                this.getCompilerContext().addRequiredColumnPriv(columnDescriptor);
            }
        }
        this.getCompilerContext().popCurrentPrivType();
    }

    ConstraintInfo getReferencedConstraintInfo() {
        return new ConstraintInfo(this.refTableName.getTableName(), this.refTableSd, this.refRcl.getColumnNames(), this.refActionDeleteRule, this.refActionUpdateRule);
    }

    public TableName getRefTableName() {
        return this.refTableName;
    }

    int getPrivType() {
        return 2;
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.refTableName != null) {
            this.refTableName = (TableName)this.refTableName.accept(visitor);
        }
    }
}

