/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class TeeOutputStream
extends OutputStream {
    @NotNull
    private final List<OutputStream> streams;

    public TeeOutputStream(OutputStream ... targetStreams) {
        this.streams = targetStreams == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<OutputStream>(Arrays.asList(targetStreams)));
    }

    public TeeOutputStream(@Nullable Collection<? extends OutputStream> targetStreams) {
        this.streams = targetStreams == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<OutputStream>(targetStreams));
    }

    @Override
    public void write(int b) throws IOException {
        for (OutputStream s : this.streams) {
            s.write(b);
        }
    }

    @Override
    public void write(@NotNull byte[] b) throws IOException {
        for (OutputStream s : this.streams) {
            s.write(b);
        }
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) throws IOException {
        for (OutputStream s : this.streams) {
            s.write(b, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        for (OutputStream s : this.streams) {
            s.flush();
        }
    }

    @Override
    public void close() throws IOException {
        IOException exceptionToThrow = null;
        for (OutputStream s : this.streams) {
            try {
                s.close();
            }
            catch (IOException ioe) {
                Debug.debugException(ioe);
                if (exceptionToThrow != null) continue;
                exceptionToThrow = ioe;
            }
        }
        if (exceptionToThrow != null) {
            throw exceptionToThrow;
        }
    }
}

