/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.spring.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.xbean.spring.util.SpringVisitor;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;

public abstract class AbstractSpringVisitor
implements SpringVisitor {
    @Override
    public void visitBeanFactory(ConfigurableListableBeanFactory beanRegistry, Object data) throws BeansException {
        String[] beanNames = beanRegistry.getBeanDefinitionNames();
        for (int i = 0; i < beanNames.length; ++i) {
            String beanName = beanNames[i];
            this.visitBeanDefinition(beanName, beanRegistry.getBeanDefinition(beanName), data);
        }
    }

    @Override
    public void visitBeanDefinitionHolder(BeanDefinitionHolder beanDefinitionHolder, Object data) throws BeansException {
        this.visitBeanDefinition(beanDefinitionHolder.getBeanName(), beanDefinitionHolder.getBeanDefinition(), data);
    }

    @Override
    public void visitBeanDefinition(String beanName, BeanDefinition beanDefinition, Object data) throws BeansException {
        this.visitBeanDefinition(beanDefinition, data);
    }

    @Override
    public void visitBeanDefinition(BeanDefinition beanDefinition, Object data) throws BeansException {
        this.visitConstructorArgumentValues(beanDefinition.getConstructorArgumentValues(), data);
        this.visitMutablePropertyValues(beanDefinition.getPropertyValues(), data);
    }

    @Override
    public void visitMutablePropertyValues(MutablePropertyValues propertyValues, Object data) throws BeansException {
        PropertyValue[] values = propertyValues.getPropertyValues();
        for (int i = 0; i < values.length; ++i) {
            this.visitPropertyValue(values[i], data);
        }
    }

    @Override
    public void visitConstructorArgumentValues(ConstructorArgumentValues constructorArgumentValues, Object data) throws BeansException {
        Map indexedArgumentValues = constructorArgumentValues.getIndexedArgumentValues();
        Iterator iterator = indexedArgumentValues.values().iterator();
        while (iterator.hasNext()) {
            this.visitConstructorArgumentValue((ConstructorArgumentValues.ValueHolder)iterator.next(), data);
        }
        List genericArgumentValues = constructorArgumentValues.getGenericArgumentValues();
        Iterator iterator2 = genericArgumentValues.iterator();
        while (iterator2.hasNext()) {
            this.visitConstructorArgumentValue((ConstructorArgumentValues.ValueHolder)iterator2.next(), data);
        }
    }

    @Override
    public void visitConstructorArgumentValue(ConstructorArgumentValues.ValueHolder valueHolder, Object data) throws BeansException {
        this.visitNext(valueHolder.getValue(), data);
    }

    @Override
    public void visitPropertyValue(PropertyValue propertyValue, Object data) throws BeansException {
        this.visitNext(propertyValue.getValue(), data);
    }

    @Override
    public void visitRuntimeBeanReference(RuntimeBeanReference beanReference, Object data) throws BeansException {
    }

    @Override
    public void visitCollection(Collection collection, Object data) throws BeansException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.visitNext(iterator.next(), data);
        }
    }

    @Override
    public void visitMap(Map map, Object data) throws BeansException {
        for (Map.Entry entry : map.entrySet()) {
            this.visitNext(entry.getKey(), data);
            this.visitNext(entry.getValue(), data);
        }
    }

    @Override
    public void visitObject(Object value, Object data) throws BeansException {
    }

    protected void visitNext(Object value, Object data) throws BeansException {
        if (value == null) {
            return;
        }
        if (value instanceof ConfigurableListableBeanFactory) {
            this.visitBeanFactory((ConfigurableListableBeanFactory)value, data);
        } else if (value instanceof BeanDefinitionHolder) {
            this.visitBeanDefinitionHolder((BeanDefinitionHolder)value, data);
        } else if (value instanceof BeanDefinition) {
            this.visitBeanDefinition((BeanDefinition)value, data);
        } else if (value instanceof ConstructorArgumentValues) {
            this.visitConstructorArgumentValues((ConstructorArgumentValues)value, data);
        } else if (value instanceof ConstructorArgumentValues.ValueHolder) {
            this.visitConstructorArgumentValue((ConstructorArgumentValues.ValueHolder)value, data);
        } else if (value instanceof MutablePropertyValues) {
            this.visitMutablePropertyValues((MutablePropertyValues)value, data);
        } else if (value instanceof PropertyValue) {
            this.visitPropertyValue((PropertyValue)value, data);
        } else if (value instanceof RuntimeBeanReference) {
            this.visitRuntimeBeanReference((RuntimeBeanReference)value, data);
        } else if (value instanceof Map) {
            this.visitMap((Map)value, data);
        } else if (value instanceof Collection) {
            this.visitCollection((Collection)value, data);
        } else {
            this.visitObject(value, data);
        }
    }
}

