/****************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one   *
 * or more contributor license agreements.  See the NOTICE file *
 * distributed with this work for additional information        *
 * regarding copyright ownership.  The ASF licenses this file   *
 * to you under the Apache License, Version 2.0 (the            *
 * "License"); you may not use this file except in compliance   *
 * with the License.  You may obtain a copy of the License at   *
 *                                                              *
 *   http://www.apache.org/licenses/LICENSE-2.0                 *
 *                                                              *
 * Unless required by applicable law or agreed to in writing,   *
 * software distributed under the License is distributed on an  *
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY       *
 * KIND, either express or implied.  See the License for the    *
 * specific language governing permissions and limitations      *
 * under the License.                                           *
 ****************************************************************/
package org.apache.james.smtpserver.jmx;

/**
 * JMX Bean which shows Hook statistics
 */
public interface HookStatsMBean {

    /**
     * Return the name of the Hook
     */
    String getName();

    /**
     * Return the count of how many OK the hook returned
     */
    long getOk();

    /**
     * Return the count of how many DECLINED the hook returned
     */
    long getDeclined();

    /**
     * Return the count of how many DENY the hook returned
     */
    long getDeny();

    /**
     * Return the count of how many DENYSOFT the hook returned
     */
    long getDenysoft();

    /**
     * Return the count of how many transaction this hook as processed
     */
    long getAll();
}
