/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.cassandra;

import com.datastax.oss.driver.api.core.type.DataTypes;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.blob.cassandra.BlobTables;

public interface CassandraBlobModule {
    public static final CassandraModule MODULE = CassandraModule.builder().table("blobParts").comment("Holds blob parts composing blobs in the default bucket.Messages` headers and bodies are stored, chunked in blobparts.").statement(statement -> types -> statement.withPartitionKey(BlobTables.DefaultBucketBlobParts.ID, DataTypes.TEXT).withClusteringColumn(BlobTables.DefaultBucketBlobParts.CHUNK_NUMBER, DataTypes.INT).withColumn(BlobTables.DefaultBucketBlobParts.DATA, DataTypes.BLOB)).table("blobs").comment("Holds information for retrieving all blob parts composing this blob within the default bucket. Messages` headers and bodies are stored as blobparts.").statement(statement -> types -> statement.withPartitionKey(BlobTables.DefaultBucketBlobTable.ID, DataTypes.TEXT).withClusteringColumn(BlobTables.DefaultBucketBlobTable.NUMBER_OF_CHUNK, DataTypes.INT)).table("blobPartsInBucket").comment("Holds blob parts composing blobs in a non-default bucket.Messages` headers and bodies are stored, chunked in blobparts.").statement(statement -> types -> statement.withPartitionKey(BlobTables.BucketBlobParts.BUCKET, DataTypes.TEXT).withPartitionKey(BlobTables.BucketBlobParts.ID, DataTypes.TEXT).withClusteringColumn(BlobTables.BucketBlobParts.CHUNK_NUMBER, DataTypes.INT).withColumn(BlobTables.DefaultBucketBlobParts.DATA, DataTypes.BLOB)).table("blobsInBucket").comment("Holds information for retrieving all blob parts composing this blob in a non-default bucket. Messages` headers and bodies are stored as blobparts.").statement(statement -> types -> statement.withPartitionKey(BlobTables.BucketBlobParts.BUCKET, DataTypes.TEXT).withPartitionKey(BlobTables.BucketBlobParts.ID, DataTypes.TEXT).withClusteringColumn(BlobTables.BucketBlobTable.NUMBER_OF_CHUNK, DataTypes.INT)).build();
}

