/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.dlp.eventsourcing.cassandra;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.dlp.api.DLPConfigurationItem;

public class DLPConfigurationItemDTO {
    private final String id;
    private final Optional<String> explanation;
    private final String expression;
    private final boolean targetsContent;
    private final boolean targetsSender;
    private final boolean targetsRecipients;

    public static DLPConfigurationItemDTO from(DLPConfigurationItem dlpConfiguration) {
        DLPConfigurationItem.Targets targets = dlpConfiguration.getTargets();
        return new DLPConfigurationItemDTO(dlpConfiguration.getId().asString(), dlpConfiguration.getExplanation(), dlpConfiguration.getRegexp().pattern(), targets.isContentTargeted(), targets.isSenderTargeted(), targets.isRecipientTargeted());
    }

    public static List<DLPConfigurationItemDTO> from(List<DLPConfigurationItem> configurationItems) {
        Preconditions.checkNotNull(configurationItems);
        return (List)configurationItems.stream().map(DLPConfigurationItemDTO::from).collect(ImmutableList.toImmutableList());
    }

    public static List<DLPConfigurationItem> fromDTOs(List<DLPConfigurationItemDTO> configurationItems) {
        Preconditions.checkNotNull(configurationItems);
        return (List)configurationItems.stream().map(DLPConfigurationItemDTO::toDLPConfiguration).collect(ImmutableList.toImmutableList());
    }

    @JsonCreator
    private DLPConfigurationItemDTO(@JsonProperty(value="id") String id, @JsonProperty(value="explanation") Optional<String> explanation, @JsonProperty(value="expression") String expression, @JsonProperty(value="targetsContent") boolean targetsContent, @JsonProperty(value="targetsSender") boolean targetsSender, @JsonProperty(value="targetsRecipients") boolean targetsRecipients) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)expression);
        this.id = id;
        this.explanation = explanation;
        this.expression = expression;
        this.targetsContent = targetsContent;
        this.targetsSender = targetsSender;
        this.targetsRecipients = targetsRecipients;
    }

    public String getId() {
        return this.id;
    }

    public Optional<String> getExplanation() {
        return this.explanation;
    }

    public String getExpression() {
        return this.expression;
    }

    public boolean isTargetsContent() {
        return this.targetsContent;
    }

    public boolean isTargetsSender() {
        return this.targetsSender;
    }

    public boolean isTargetsRecipients() {
        return this.targetsRecipients;
    }

    @JsonIgnore
    public DLPConfigurationItem toDLPConfiguration() {
        return DLPConfigurationItem.builder().id(DLPConfigurationItem.Id.of((String)this.id)).expression(this.expression).explanation(this.explanation).targetsSender(this.targetsSender).targetsContent(this.targetsContent).targetsRecipients(this.targetsRecipients).build();
    }

    public final boolean equals(Object o) {
        if (o instanceof DLPConfigurationItemDTO) {
            DLPConfigurationItemDTO that = (DLPConfigurationItemDTO)o;
            return Objects.equals(this.targetsContent, that.targetsContent) && Objects.equals(this.targetsSender, that.targetsSender) && Objects.equals(this.targetsRecipients, that.targetsRecipients) && Objects.equals(this.explanation, that.explanation) && Objects.equals(this.expression, that.expression) && Objects.equals(this.id, that.id);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.id, this.explanation, this.expression, this.targetsContent, this.targetsSender, this.targetsRecipients);
    }
}

