/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public class RunArguments {
    private final Set<Argument> arguments;

    public static RunArguments empty() {
        return new RunArguments(Set.of());
    }

    public static RunArguments from(String[] args) {
        return new RunArguments(Arrays.stream(args).map(Argument::parse).collect(Collectors.toSet()));
    }

    public RunArguments(Set<Argument> arguments) {
        this.arguments = arguments;
    }

    public Set<Argument> getArguments() {
        return this.arguments;
    }

    public boolean contain(Argument argument) {
        return this.getArguments().contains((Object)argument);
    }

    public static enum Argument {
        GENERATE_KEYSTORE("--generate-keystore");

        private final String rawValue;

        private Argument(String rawValue) {
            this.rawValue = rawValue;
        }

        public static Argument parse(String arg) {
            return Arrays.stream(Argument.values()).filter(argument -> argument.rawValue.equals(arg)).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid running argument: " + arg));
        }

        public String getRawValue() {
            return this.rawValue;
        }
    }
}

