/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.json;

import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;

class JsonDataImpl
implements JsonData {
    private final Object value;
    private final JsonpMapper mapper;

    JsonDataImpl(Object value, JsonpMapper mapper) {
        this.value = value;
        this.mapper = mapper;
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public JsonValue toJson() {
        return this.toJson(null);
    }

    @Override
    public JsonValue toJson(JsonpMapper mapper) {
        if (this.value instanceof JsonValue) {
            return (JsonValue)this.value;
        }
        JsonpMapper jsonpMapper = mapper = mapper != null ? mapper : this.mapper;
        if (mapper == null) {
            throw new IllegalStateException("Contains a '" + this.value.getClass().getName() + "' that cannot be converted to a JsonValue without a mapper");
        }
        JsonParser parser = this.getParser(mapper);
        parser.next();
        return parser.getValue();
    }

    @Override
    public <T> T to(Class<T> clazz) {
        return this.to(clazz, null);
    }

    @Override
    public <T> T to(Class<T> clazz, JsonpMapper mapper) {
        if (clazz.isAssignableFrom(this.value.getClass())) {
            return (T)this.value;
        }
        mapper = this.getMapper(mapper);
        JsonParser parser = this.getParser(mapper);
        return mapper.deserialize(parser, clazz);
    }

    @Override
    public <T> T deserialize(JsonpDeserializer<T> deserializer) {
        return this.deserialize(deserializer, null);
    }

    @Override
    public <T> T deserialize(JsonpDeserializer<T> deserializer, JsonpMapper mapper) {
        mapper = this.getMapper(mapper);
        return deserializer.deserialize(this.getParser(mapper), mapper);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this.value instanceof JsonValue) {
            generator.write((JsonValue)this.value);
        } else {
            (this.mapper != null ? this.mapper : mapper).serialize(this.value, generator);
        }
    }

    private JsonpMapper getMapper(JsonpMapper localMapper) {
        JsonpMapper jsonpMapper = localMapper = localMapper != null ? localMapper : this.mapper;
        if (localMapper == null) {
            throw new IllegalStateException("A JsonpMapper is needed to convert JsonData");
        }
        return localMapper;
    }

    private JsonParser getParser(JsonpMapper mapper) {
        StringWriter sw = new StringWriter();
        JsonGenerator generator = mapper.jsonProvider().createGenerator((Writer)sw);
        if (this.value instanceof JsonValue) {
            generator.write((JsonValue)this.value);
        } else {
            mapper.serialize(this.value, generator);
        }
        generator.close();
        return mapper.jsonProvider().createParser((Reader)new StringReader(sw.toString()));
    }
}

