/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jsieve.Executable;
import org.apache.jsieve.SieveContext;
import org.apache.jsieve.Test;
import org.apache.jsieve.exception.SieveException;
import org.apache.jsieve.mail.MailAdapter;

public class TestList
implements Executable {
    private List<Test> fieldTests;

    private TestList() {
    }

    public TestList(List<Test> children) {
        this();
        this.setTests(children);
    }

    public TestList(Test child) {
        this();
        ArrayList<Test> children = new ArrayList<Test>();
        children.add(child);
        this.setTests(children);
    }

    @Override
    public Object execute(MailAdapter mail, SieveContext context) throws SieveException {
        return this.allTestsPass(mail, context);
    }

    public boolean allTestsPass(MailAdapter mail, SieveContext context) throws SieveException {
        Test test;
        boolean result = true;
        Iterator<Test> iterator = this.getTests().iterator();
        while (iterator.hasNext() && (result = (test = iterator.next()).isTestPassed(mail, context))) {
        }
        return result;
    }

    public boolean anyTestsPass(MailAdapter mail, SieveContext context) throws SieveException {
        Test test;
        boolean result = false;
        Iterator<Test> iterator = this.getTests().iterator();
        while (iterator.hasNext() && !(result = (test = iterator.next()).isTestPassed(mail, context))) {
        }
        return result;
    }

    public List<Test> getTests() {
        return this.fieldTests;
    }

    protected void setTests(List<Test> children) {
        this.fieldTests = children;
    }

    public String toString() {
        return "TEST LIST: " + this.fieldTests;
    }

    public boolean isEmpty() {
        return this.fieldTests.isEmpty();
    }
}

