/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class FilterFileReader
implements Closeable {
    @NotNull
    private final AtomicLong lineNumberCounter;
    @NotNull
    private final BufferedReader reader;
    @NotNull
    private final File filterFile;

    public FilterFileReader(@NotNull String path) throws IOException {
        this(new File(path));
    }

    public FilterFileReader(@NotNull File filterFile) throws IOException {
        this.filterFile = filterFile;
        this.reader = new BufferedReader(new FileReader(filterFile));
        this.lineNumberCounter = new AtomicLong(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Filter readFilter() throws IOException, LDAPException {
        long lineNumber;
        String line;
        String filterString;
        do {
            FilterFileReader filterFileReader = this;
            synchronized (filterFileReader) {
                line = this.reader.readLine();
                lineNumber = this.lineNumberCounter.incrementAndGet();
            }
            if (line != null) continue;
            return null;
        } while ((filterString = line.trim()).isEmpty() || filterString.startsWith("#"));
        try {
            return Filter.create(filterString);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPException(ResultCode.FILTER_ERROR, UtilityMessages.ERR_FILTER_FILE_READER_CANNOT_PARSE_FILTER.get(filterString, lineNumber, this.filterFile.getAbsolutePath(), le.getMessage()), le);
        }
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

