/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.util.CryptoHelper;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.ssl.SSLMessages;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class TrustStoreTrustManager
implements X509TrustManager,
Serializable {
    @NotNull
    private static final X509Certificate[] NO_CERTIFICATES = new X509Certificate[0];
    private static final long serialVersionUID = -4093869102727719415L;
    private final boolean examineValidityDates;
    @Nullable
    private final char[] trustStorePIN;
    @NotNull
    private final String trustStoreFile;
    @NotNull
    private final String trustStoreFormat;

    public TrustStoreTrustManager(@NotNull File trustStoreFile) {
        this(trustStoreFile.getAbsolutePath(), null, null, true);
    }

    public TrustStoreTrustManager(@NotNull String trustStoreFile) {
        this(trustStoreFile, null, null, true);
    }

    public TrustStoreTrustManager(@NotNull File trustStoreFile, @Nullable char[] trustStorePIN, @Nullable String trustStoreFormat, boolean examineValidityDates) {
        this(trustStoreFile.getAbsolutePath(), trustStorePIN, trustStoreFormat, examineValidityDates);
    }

    public TrustStoreTrustManager(@NotNull String trustStoreFile, @Nullable char[] trustStorePIN, @Nullable String trustStoreFormat, boolean examineValidityDates) {
        Validator.ensureNotNull(trustStoreFile);
        this.trustStoreFile = trustStoreFile;
        this.trustStorePIN = trustStorePIN;
        this.examineValidityDates = examineValidityDates;
        this.trustStoreFormat = trustStoreFormat == null ? CryptoHelper.getDefaultKeyStoreType() : trustStoreFormat;
    }

    @NotNull
    public String getTrustStoreFile() {
        return this.trustStoreFile;
    }

    @NotNull
    public String getTrustStoreFormat() {
        return this.trustStoreFormat;
    }

    public boolean examineValidityDates() {
        return this.examineValidityDates;
    }

    @NotNull
    private X509TrustManager[] getTrustManagers(@NotNull X509Certificate[] chain) throws CertificateException {
        KeyStore ks;
        File f;
        if (this.examineValidityDates) {
            Date d = new Date();
            for (X509Certificate c : chain) {
                c.checkValidity(d);
            }
        }
        if (!(f = new File(this.trustStoreFile)).exists()) {
            throw new CertificateException(SSLMessages.ERR_TRUSTSTORE_NO_SUCH_FILE.get(this.trustStoreFile));
        }
        try {
            ks = CryptoHelper.getKeyStore(this.trustStoreFormat);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertificateException(SSLMessages.ERR_TRUSTSTORE_UNSUPPORTED_FORMAT.get(this.trustStoreFormat), e);
        }
        try (FileInputStream inputStream = new FileInputStream(f);){
            ks.load(inputStream, this.trustStorePIN);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertificateException(SSLMessages.ERR_TRUSTSTORE_CANNOT_LOAD.get(this.trustStoreFile, this.trustStoreFormat, StaticUtils.getExceptionMessage(e)), e);
        }
        try {
            TrustManagerFactory factory = CryptoHelper.getTrustManagerFactory();
            factory.init(ks);
            TrustManager[] trustManagers = factory.getTrustManagers();
            X509TrustManager[] x509TrustManagers = new X509TrustManager[trustManagers.length];
            for (int i = 0; i < trustManagers.length; ++i) {
                x509TrustManagers[i] = (X509TrustManager)trustManagers[i];
            }
            return x509TrustManagers;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertificateException(SSLMessages.ERR_TRUSTSTORE_CANNOT_GET_TRUST_MANAGERS.get(this.trustStoreFile, this.trustStoreFormat, StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Override
    public void checkClientTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) throws CertificateException {
        for (X509TrustManager m : this.getTrustManagers(chain)) {
            m.checkClientTrusted(chain, authType);
        }
    }

    @Override
    public void checkServerTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) throws CertificateException {
        for (X509TrustManager m : this.getTrustManagers(chain)) {
            m.checkServerTrusted(chain, authType);
        }
    }

    @Override
    @NotNull
    public X509Certificate[] getAcceptedIssuers() {
        return NO_CERTIFICATES;
    }
}

