/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.BucketAggregationBase;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class MissingAggregation
extends BucketAggregationBase
implements AggregationVariant {
    @Nullable
    private final String field;
    @Nullable
    private final FieldValue missing;
    public static final JsonpDeserializer<MissingAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MissingAggregation::setupMissingAggregationDeserializer);

    private MissingAggregation(Builder builder) {
        super(builder);
        this.field = builder.field;
        this.missing = builder.missing;
    }

    public static MissingAggregation of(Function<Builder, ObjectBuilder<MissingAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.Missing;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nullable
    public final FieldValue missing() {
        return this.missing;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.missing != null) {
            generator.writeKey("missing");
            this.missing.serialize(generator, mapper);
        }
    }

    protected static void setupMissingAggregationDeserializer(ObjectDeserializer<Builder> op) {
        BucketAggregationBase.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::missing, FieldValue._DESERIALIZER, "missing");
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<MissingAggregation> {
        @Nullable
        private String field;
        @Nullable
        private FieldValue missing;

        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public final Builder missing(@Nullable FieldValue value) {
            this.missing = value;
            return this;
        }

        public final Builder missing(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.missing(fn.apply(new FieldValue.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MissingAggregation build() {
            this._checkSingleUse();
            return new MissingAggregation(this);
        }
    }
}

