/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.terms;

import org.apache.james.jspf.core.DNSLookupContinuation;
import org.apache.james.jspf.core.SPFChecker;
import org.apache.james.jspf.core.SPFSession;
import org.apache.james.jspf.core.exceptions.NeutralException;
import org.apache.james.jspf.core.exceptions.NoneException;
import org.apache.james.jspf.core.exceptions.PermErrorException;
import org.apache.james.jspf.core.exceptions.TempErrorException;
import org.apache.james.jspf.terms.Mechanism;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Directive
implements SPFChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(Directive.class);
    public static final String ATTRIBUTE_MECHANISM_RESULT = "Mechanism.result";
    protected String qualifier = "+";
    private Mechanism mechanism = null;
    private MechanismResultChecker resultChecker;

    public Directive(String qualifier, Mechanism mechanism) throws PermErrorException {
        if (qualifier == null) {
            throw new PermErrorException("Qualifier cannot be null");
        }
        this.qualifier = qualifier;
        if (mechanism == null) {
            throw new PermErrorException("Mechanism cannot be null");
        }
        this.resultChecker = new MechanismResultChecker();
        this.mechanism = mechanism;
    }

    @Override
    public DNSLookupContinuation checkSPF(SPFSession spfSession) throws PermErrorException, TempErrorException, NoneException, NeutralException {
        if (spfSession.getCurrentResult() == null && spfSession.getCurrentResultExpanded() == null) {
            spfSession.removeAttribute(ATTRIBUTE_MECHANISM_RESULT);
            spfSession.pushChecker(this.resultChecker);
            spfSession.pushChecker(this.mechanism);
        }
        return null;
    }

    public Mechanism getMechanism() {
        return this.mechanism;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String toString() {
        return this.qualifier + this.mechanism;
    }

    private final class MechanismResultChecker
    implements SPFChecker {
        private MechanismResultChecker() {
        }

        @Override
        public DNSLookupContinuation checkSPF(SPFSession spfData) throws PermErrorException, TempErrorException, NeutralException, NoneException {
            Boolean res = (Boolean)spfData.getAttribute(Directive.ATTRIBUTE_MECHANISM_RESULT);
            if (res == null || res.booleanValue()) {
                if (Directive.this.qualifier.equals("")) {
                    spfData.setCurrentResult("+");
                } else {
                    spfData.setCurrentResult(Directive.this.qualifier);
                }
                LOGGER.info("Processed directive matched: {} returned {}", (Object)Directive.this, (Object)spfData.getCurrentResult());
            } else {
                LOGGER.debug("Processed directive NOT matched: {}", (Object)this);
            }
            return null;
        }
    }
}

