/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.util.stream.Collectors;
import org.apache.james.core.Domain;
import org.apache.james.domainlist.api.AutoDetectedDomainRemovalException;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.api.SameSourceAndDestinationException;
import org.apache.james.task.TaskManager;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.dto.DomainAliasResponse;
import org.apache.james.webadmin.service.DeleteUserDataService;
import org.apache.james.webadmin.service.DeleteUsersDataOfDomainTask;
import org.apache.james.webadmin.service.DomainAliasService;
import org.apache.james.webadmin.tasks.TaskFromRequestRegistry;
import org.apache.james.webadmin.tasks.TaskRegistrationKey;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.Responses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.HaltException;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Route;
import spark.Service;

public class DomainsRoutes
implements Routes {
    public static final String DOMAINS = "/domains";
    private static final Logger LOGGER = LoggerFactory.getLogger(DomainsRoutes.class);
    private static final String DOMAIN_NAME = ":domainName";
    private static final String SOURCE_DOMAIN = ":sourceDomain";
    private static final String DESTINATION_DOMAIN = ":destinationDomain";
    private static final String SPECIFIC_DOMAIN = "/domains/:domainName";
    private static final String ALIASES = "aliases";
    private static final String DOMAIN_ALIASES = "/domains/:domainName/aliases";
    private static final String DELETE_ALL_USERS_DATA_OF_A_DOMAIN_PATH = "/domains/:domainName";
    private static final String SPECIFIC_ALIAS = "/domains/:destinationDomain/aliases/:sourceDomain";
    private static final TaskRegistrationKey DELETE_USERS_DATA = TaskRegistrationKey.of((String)"deleteData");
    private final DomainList domainList;
    private final DomainAliasService domainAliasService;
    private final JsonTransformer jsonTransformer;
    private final DeleteUserDataService deleteUserDataService;
    private final UsersRepository usersRepository;
    private final TaskManager taskManager;
    private Service service;

    @Inject
    DomainsRoutes(DomainList domainList, DomainAliasService domainAliasService, JsonTransformer jsonTransformer, DeleteUserDataService deleteUserDataService, UsersRepository usersRepository, TaskManager taskManager) {
        this.domainList = domainList;
        this.domainAliasService = domainAliasService;
        this.jsonTransformer = jsonTransformer;
        this.deleteUserDataService = deleteUserDataService;
        this.usersRepository = usersRepository;
        this.taskManager = taskManager;
    }

    public String getBasePath() {
        return DOMAINS;
    }

    public void define(Service service) {
        this.service = service;
        this.defineGetDomains();
        this.defineDomainExists();
        this.defineAddDomain();
        this.defineDeleteDomain();
        this.defineListAliases(service);
        this.defineAddAlias(service);
        this.defineRemoveAlias(service);
        service.post("/domains/:domainName", this.deleteAllUsersData(), (ResponseTransformer)this.jsonTransformer);
    }

    public Route deleteAllUsersData() {
        return TaskFromRequestRegistry.builder().parameterName("action").register(DELETE_USERS_DATA, request -> {
            Domain domain = this.checkValidDomain(request.params(DOMAIN_NAME));
            Preconditions.checkArgument((boolean)this.domainList.containsDomain(domain), (Object)"'domainName' parameter should be an existing domain");
            return new DeleteUsersDataOfDomainTask(this.deleteUserDataService, domain, this.usersRepository);
        }).buildAsRoute(this.taskManager);
    }

    public void defineDeleteDomain() {
        this.service.delete("/domains/:domainName", this::removeDomain);
    }

    public void defineAddDomain() {
        this.service.put("/domains/:domainName", this::addDomain);
    }

    public void defineDomainExists() {
        this.service.get("/domains/:domainName", this::exists);
    }

    public void defineGetDomains() {
        this.service.get(DOMAINS, (request, response) -> this.domainList.getDomains().stream().map(Domain::name).collect(Collectors.toList()), (ResponseTransformer)this.jsonTransformer);
    }

    public void defineListAliases(Service service) {
        service.get(DOMAIN_ALIASES, this::listDomainAliases, (ResponseTransformer)this.jsonTransformer);
    }

    public void defineRemoveAlias(Service service) {
        service.delete(SPECIFIC_ALIAS, this::removeDomainAlias, (ResponseTransformer)this.jsonTransformer);
    }

    public void defineAddAlias(Service service) {
        service.put(SPECIFIC_ALIAS, this::addDomainAlias, (ResponseTransformer)this.jsonTransformer);
    }

    private String removeDomain(Request request, Response response) throws RecipientRewriteTableException {
        try {
            Domain domain = this.checkValidDomain(request.params(DOMAIN_NAME));
            this.domainList.removeDomain(domain);
            this.domainAliasService.removeCorrespondingDomainAliases(domain);
        }
        catch (AutoDetectedDomainRemovalException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Can not remove domain").cause((Exception)((Object)e)).haltError();
        }
        catch (DomainListException e) {
            LOGGER.info("{} did not exists", (Object)request.params(DOMAIN_NAME));
        }
        return Responses.returnNoContent((Response)response);
    }

    private String addDomain(Request request, Response response) {
        Domain domain = this.checkValidDomain(request.params(DOMAIN_NAME));
        try {
            this.domainList.addDomain(domain);
            return Responses.returnNoContent((Response)response);
        }
        catch (DomainListException e) {
            LOGGER.info("{} already exists", (Object)domain);
            throw ErrorResponder.builder().statusCode(204).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("%s already exists", new Object[]{domain.name()}).cause((Exception)((Object)e)).haltError();
        }
        catch (IllegalArgumentException e) {
            LOGGER.info("Invalid request for domain creation");
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Invalid request for domain creation %s", new Object[]{domain.name()}).cause((Exception)e).haltError();
        }
    }

    private Domain checkValidDomain(String domainName) {
        try {
            return Domain.of((String)domainName);
        }
        catch (IllegalArgumentException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Invalid request for domain creation %s", new Object[]{domainName}).cause((Exception)e).haltError();
        }
    }

    private String exists(Request request, Response response) throws DomainListException {
        Domain domain = this.checkValidDomain(request.params(DOMAIN_NAME));
        if (!this.domainList.containsDomain(domain)) {
            throw this.domainNotFound(domain);
        }
        return Responses.returnNoContent((Response)response);
    }

    private ImmutableSet<DomainAliasResponse> listDomainAliases(Request request, Response response) throws DomainListException, RecipientRewriteTableException {
        Domain domain = this.checkValidDomain(request.params(DOMAIN_NAME));
        if (!this.domainAliasService.hasAliases(domain)) {
            throw this.domainHasNoAliases(domain);
        }
        return this.domainAliasService.listDomainAliases(domain);
    }

    private String addDomainAlias(Request request, Response response) throws DomainListException, RecipientRewriteTableException {
        Domain sourceDomain = this.checkValidDomain(request.params(SOURCE_DOMAIN));
        Domain destinationDomain = this.checkValidDomain(request.params(DESTINATION_DOMAIN));
        try {
            this.domainAliasService.addDomainAlias(sourceDomain, destinationDomain);
            return Responses.returnNoContent((Response)response);
        }
        catch (DomainAliasService.DomainNotFound e) {
            throw this.domainNotFound(e.getDomain());
        }
        catch (SameSourceAndDestinationException e) {
            throw this.sameSourceAndDestination(sourceDomain);
        }
    }

    private String removeDomainAlias(Request request, Response response) throws DomainListException, RecipientRewriteTableException {
        Domain sourceDomain = this.checkValidDomain(request.params(SOURCE_DOMAIN));
        Domain destinationDomain = this.checkValidDomain(request.params(DESTINATION_DOMAIN));
        try {
            this.domainAliasService.removeDomainAlias(sourceDomain, destinationDomain);
            return Responses.returnNoContent((Response)response);
        }
        catch (DomainAliasService.DomainNotFound e) {
            throw this.domainNotFound(e.getDomain());
        }
        catch (SameSourceAndDestinationException e) {
            throw this.sameSourceAndDestination(sourceDomain);
        }
    }

    private HaltException domainNotFound(Domain domain) {
        return ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("The domain list does not contain: %s", new Object[]{domain.name()}).haltError();
    }

    private HaltException domainHasNoAliases(Domain domain) {
        return ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("The following domain is not in the domain list and has no registered local aliases: %s", new Object[]{domain.name()}).haltError();
    }

    private HaltException sameSourceAndDestination(Domain sameDomain) {
        return ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Source domain and destination domain can not have same value(%s)", new Object[]{sameDomain.name()}).haltError();
    }
}

