/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.pop3server.netty;

import io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.james.pop3server.core.CoreCmdHandlerLoader;
import org.apache.james.pop3server.jmx.JMXHandlersLoader;
import org.apache.james.pop3server.netty.POP3ServerMBean;
import org.apache.james.protocols.api.Protocol;
import org.apache.james.protocols.api.ProtocolConfiguration;
import org.apache.james.protocols.lib.handler.HandlersPackage;
import org.apache.james.protocols.lib.netty.AbstractProtocolAsyncServer;
import org.apache.james.protocols.netty.AllButStartTlsLineChannelHandlerFactory;
import org.apache.james.protocols.netty.BasicChannelInboundHandler;
import org.apache.james.protocols.netty.ChannelHandlerFactory;
import org.apache.james.protocols.netty.ProtocolMDCContextFactory;
import org.apache.james.protocols.pop3.POP3Protocol;

public class POP3Server
extends AbstractProtocolAsyncServer
implements POP3ServerMBean {
    private final ProtocolConfiguration theConfigData = new POP3Configuration();
    private POP3Protocol protocol;

    protected int getDefaultPort() {
        return 110;
    }

    public String getServiceType() {
        return "POP3 Service";
    }

    protected void preInit() throws Exception {
        super.preInit();
        this.protocol = new POP3Protocol(this.getProtocolHandlerChain(), this.theConfigData);
    }

    protected String getDefaultJMXName() {
        return "pop3server";
    }

    protected ChannelInboundHandlerAdapter createCoreHandler() {
        return new BasicChannelInboundHandler((ProtocolMDCContextFactory)new ProtocolMDCContextFactory.Standard(), (Protocol)this.protocol, this.getEncryption(), false);
    }

    protected Class<? extends HandlersPackage> getCoreHandlersPackage() {
        return CoreCmdHandlerLoader.class;
    }

    protected Class<? extends HandlersPackage> getJMXHandlersPackage() {
        return JMXHandlersLoader.class;
    }

    protected ChannelHandlerFactory createFrameHandlerFactory() {
        return new AllButStartTlsLineChannelHandlerFactory("stls", 8192);
    }

    private class POP3Configuration
    implements ProtocolConfiguration {
        private POP3Configuration() {
        }

        public String getHelloName() {
            return POP3Server.this.getHelloName();
        }

        public String getGreeting() {
            return null;
        }

        public String getSoftwareName() {
            return "JAMES POP3 Server ";
        }
    }
}

