/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
final class WriteTimeoutHandler
extends TimerTask {
    @NotNull
    private static final AtomicReference<ObjectPair<Timer, AtomicLong>> TIMER_REFERENCE = new AtomicReference();
    private static final long TIMER_INTERVAL_MILLIS = 100L;
    @NotNull
    private final AtomicBoolean destroyed;
    @NotNull
    private final AtomicLong connectionsUsingTimer;
    @NotNull
    private final AtomicLong counter;
    @NotNull
    private final ConcurrentHashMap<Long, Long> writeTimeouts;
    @NotNull
    private final LDAPConnection connection;
    @NotNull
    private final Timer timer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WriteTimeoutHandler(@NotNull LDAPConnection connection) {
        this.connection = connection;
        this.destroyed = new AtomicBoolean(false);
        this.counter = new AtomicLong(0L);
        this.writeTimeouts = new ConcurrentHashMap(10);
        AtomicReference<ObjectPair<Timer, AtomicLong>> atomicReference = TIMER_REFERENCE;
        synchronized (atomicReference) {
            ObjectPair<Timer, AtomicLong> timerPair = TIMER_REFERENCE.get();
            if (timerPair == null) {
                this.timer = new Timer("Write Timeout Handler Timer", true);
                this.connectionsUsingTimer = new AtomicLong(1L);
                TIMER_REFERENCE.set(new ObjectPair<Timer, AtomicLong>(this.timer, this.connectionsUsingTimer));
            } else {
                this.timer = timerPair.getFirst();
                this.connectionsUsingTimer = timerPair.getSecond();
                this.connectionsUsingTimer.incrementAndGet();
            }
            this.timer.schedule((TimerTask)this, 100L, 100L);
        }
    }

    @Override
    public void run() {
        long currentTime = System.currentTimeMillis();
        Iterator<Map.Entry<Long, Long>> iterator = this.writeTimeouts.entrySet().iterator();
        while (iterator.hasNext()) {
            long closeTime = iterator.next().getValue();
            if (currentTime <= closeTime) continue;
            try {
                this.connection.getConnectionInternals(true).getSocket().close();
            }
            catch (Exception e) {
                Debug.debugException(e);
                return;
            }
        }
    }

    @Override
    public boolean cancel() {
        boolean result = super.cancel();
        this.timer.purge();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        this.cancel();
        if (this.destroyed.getAndSet(true)) {
            return;
        }
        AtomicReference<ObjectPair<Timer, AtomicLong>> atomicReference = TIMER_REFERENCE;
        synchronized (atomicReference) {
            long remainingConnectionsUsingTimer = this.connectionsUsingTimer.decrementAndGet();
            if (remainingConnectionsUsingTimer <= 0L) {
                TIMER_REFERENCE.set(null);
                this.timer.cancel();
            }
        }
    }

    long beginWrite(long timeoutMillis) {
        long id = this.counter.getAndIncrement();
        long writeExpirationTime = System.currentTimeMillis() + timeoutMillis;
        this.writeTimeouts.put(id, writeExpirationTime);
        return id;
    }

    void writeCompleted(long writeID) {
        this.writeTimeouts.remove(writeID);
    }
}

