/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.tasks.CollectSupportDataSecurityLevel;
import com.unboundid.ldap.sdk.unboundidds.tasks.CollectSupportDataTaskProperties;
import com.unboundid.ldap.sdk.unboundidds.tasks.Task;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskProperty;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.DurationArgument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class CollectSupportDataTask
extends Task {
    @NotNull
    static final String COLLECT_SUPPORT_DATA_TASK_CLASS = "com.unboundid.directory.server.tasks.CollectSupportDataTask";
    @NotNull
    private static final String ATTR_PREFIX = "ds-task-collect-support-data-";
    @NotNull
    public static final String ATTR_COMMENT = "ds-task-collect-support-data-comment";
    @NotNull
    public static final String ATTR_ENCRYPTION_PASSPHRASE_FILE = "ds-task-collect-support-data-encryption-passphrase-file";
    @NotNull
    public static final String ATTR_INCLUDE_BINARY_FILES = "ds-task-collect-support-data-include-binary-files";
    @NotNull
    public static final String ATTR_INCLUDE_EXPENSIVE_DATA = "ds-task-collect-support-data-include-expensive-data";
    @NotNull
    public static final String ATTR_INCLUDE_EXTENSION_SOURCE = "ds-task-collect-support-data-include-extension-source";
    @NotNull
    public static final String ATTR_INCLUDE_REPLICATION_STATE_DUMP = "ds-task-collect-support-data-include-replication-state-dump";
    @NotNull
    public static final String ATTR_JSTACK_COUNT = "ds-task-collect-support-data-jstack-count";
    @NotNull
    public static final String ATTR_LOG_DURATION = "ds-task-collect-support-data-log-duration";
    @NotNull
    public static final String ATTR_LOG_END_TIME = "ds-task-collect-support-data-log-end-time";
    @NotNull
    public static final String ATTR_LOG_START_TIME = "ds-task-collect-support-data-log-start-time";
    @NotNull
    public static final String ATTR_LOG_FILE_HEAD_COLLECTION_SIZE_KB = "ds-task-collect-support-data-log-file-head-collection-size-kb";
    @NotNull
    public static final String ATTR_LOG_FILE_TAIL_COLLECTION_SIZE_KB = "ds-task-collect-support-data-log-file-tail-collection-size-kb";
    @NotNull
    public static final String ATTR_OUTPUT_PATH = "ds-task-collect-support-data-output-path";
    @NotNull
    public static final String ATTR_REPORT_COUNT = "ds-task-collect-support-data-report-count";
    @NotNull
    public static final String ATTR_REPORT_INTERVAL_SECONDS = "ds-task-collect-support-data-report-interval-seconds";
    @NotNull
    public static final String ATTR_RETAIN_PREVIOUS_ARCHIVE_AGE = "ds-task-collect-support-data-retain-previous-support-data-archive-age";
    @NotNull
    public static final String ATTR_RETAIN_PREVIOUS_ARCHIVE_COUNT = "ds-task-collect-support-data-retain-previous-support-data-archive-count";
    @NotNull
    public static final String ATTR_SECURITY_LEVEL = "ds-task-collect-support-data-security-level";
    @NotNull
    public static final String ATTR_USE_SEQUENTIAL_MODE = "ds-task-collect-support-data-use-sequential-mode";
    @NotNull
    public static final String OC_COLLECT_SUPPORT_DATA_TASK = "ds-task-collect-support-data";
    @NotNull
    static final TaskProperty PROPERTY_COMMENT = new TaskProperty("ds-task-collect-support-data-comment", TaskMessages.INFO_CSD_DISPLAY_NAME_COMMENT.get(), TaskMessages.INFO_CSD_DESCRIPTION_COMMENT.get(), String.class, false, false, false);
    @NotNull
    static final TaskProperty PROPERTY_ENCRYPTION_PASSPHRASE_FILE = new TaskProperty("ds-task-collect-support-data-encryption-passphrase-file", TaskMessages.INFO_CSD_DISPLAY_NAME_ENC_PW_FILE.get(), TaskMessages.INFO_CSD_DESCRIPTION_ENC_PW_FILE.get(), String.class, false, false, false);
    @NotNull
    static final TaskProperty PROPERTY_INCLUDE_BINARY_FILES = new TaskProperty("ds-task-collect-support-data-include-binary-files", TaskMessages.INFO_CSD_DISPLAY_NAME_INCLUDE_BINARY_FILES.get(), TaskMessages.INFO_CSD_DESCRIPTION_INCLUDE_BINARY_FILES.get(), Boolean.class, false, false, false);
    @NotNull
    static final TaskProperty PROPERTY_INCLUDE_EXPENSIVE_DATA = new TaskProperty("ds-task-collect-support-data-include-expensive-data", TaskMessages.INFO_CSD_DISPLAY_NAME_INCLUDE_EXPENSIVE_DATA.get(), TaskMessages.INFO_CSD_DESCRIPTION_INCLUDE_EXPENSIVE_DATA.get(), Boolean.class, false, false, false);
    @NotNull
    static final TaskProperty PROPERTY_INCLUDE_EXTENSION_SOURCE = new TaskProperty("ds-task-collect-support-data-include-extension-source", TaskMessages.INFO_CSD_DISPLAY_NAME_INCLUDE_EXTENSION_SOURCE.get(), TaskMessages.INFO_CSD_DESCRIPTION_INCLUDE_EXTENSION_SOURCE.get(), Boolean.class, false, false, false);
    @NotNull
    static final TaskProperty PROPERTY_INCLUDE_REPLICATION_STATE_DUMP = new TaskProperty("ds-task-collect-support-data-include-replication-state-dump", TaskMessages.INFO_CSD_DISPLAY_NAME_INCLUDE_REPLICATION_STATE_DUMP.get(), TaskMessages.INFO_CSD_DESCRIPTION_INCLUDE_REPLICATION_STATE_DUMP.get(), Boolean.class, false, false, false);
    @NotNull
    static final TaskProperty PROPERTY_JSTACK_COUNT = new TaskProperty("ds-task-collect-support-data-jstack-count", TaskMessages.INFO_CSD_DISPLAY_NAME_JSTACK_COUNT.get(), TaskMessages.INFO_CSD_DESCRIPTION_JSTACK_COUNT.get(), Long.class, false, false, false);
    @NotNull
    static final TaskProperty PROPERTY_LOG_DURATION = new TaskProperty("ds-task-collect-support-data-log-duration", TaskMessages.INFO_CSD_DISPLAY_NAME_LOG_DURATION.get(), TaskMessages.INFO_CSD_DESCRIPTION_LOG_DURATION.get(), String.class, false, false, false);
    @NotNull
    static final TaskProperty PROPERTY_LOG_END_TIME = new TaskProperty("ds-task-collect-support-data-log-end-time", TaskMessages.INFO_CSD_DISPLAY_NAME_LOG_END_TIME.get(), TaskMessages.INFO_CSD_DESCRIPTION_LOG_END_TIME.get(), Date.class, false, false, false);
    @NotNull
    static final TaskProperty PROPERTY_LOG_START_TIME = new TaskProperty("ds-task-collect-support-data-log-start-time", TaskMessages.INFO_CSD_DISPLAY_NAME_LOG_START_TIME.get(), TaskMessages.INFO_CSD_DESCRIPTION_LOG_START_TIME.get(), Date.class, false, false, false);
    @NotNull
    static final TaskProperty PROPERTY_LOG_FILE_HEAD_COLLECTION_SIZE_KB = new TaskProperty("ds-task-collect-support-data-log-file-head-collection-size-kb", TaskMessages.INFO_CSD_DISPLAY_NAME_LOG_HEAD_SIZE_KB.get(), TaskMessages.INFO_CSD_DESCRIPTION_LOG_HEAD_SIZE_KB.get(), Long.class, false, false, false);
    @NotNull
    static final TaskProperty PROPERTY_LOG_FILE_TAIL_COLLECTION_SIZE_KB = new TaskProperty("ds-task-collect-support-data-log-file-tail-collection-size-kb", TaskMessages.INFO_CSD_DISPLAY_NAME_LOG_TAIL_SIZE_KB.get(), TaskMessages.INFO_CSD_DESCRIPTION_LOG_TAIL_SIZE_KB.get(), Long.class, false, false, false);
    @NotNull
    static final TaskProperty PROPERTY_OUTPUT_PATH = new TaskProperty("ds-task-collect-support-data-output-path", TaskMessages.INFO_CSD_DISPLAY_NAME_OUTPUT_PATH.get(), TaskMessages.INFO_CSD_DESCRIPTION_OUTPUT_PATH.get(), String.class, false, false, false);
    @NotNull
    static final TaskProperty PROPERTY_REPORT_COUNT = new TaskProperty("ds-task-collect-support-data-report-count", TaskMessages.INFO_CSD_DISPLAY_NAME_REPORT_COUNT.get(), TaskMessages.INFO_CSD_DESCRIPTION_REPORT_COUNT.get(), Long.class, false, false, false);
    @NotNull
    static final TaskProperty PROPERTY_REPORT_INTERVAL_SECONDS = new TaskProperty("ds-task-collect-support-data-report-interval-seconds", TaskMessages.INFO_CSD_DISPLAY_NAME_REPORT_INTERVAL.get(), TaskMessages.INFO_CSD_DESCRIPTION_REPORT_INTERVAL.get(), Long.class, false, false, false);
    @NotNull
    static final TaskProperty PROPERTY_RETAIN_PREVIOUS_ARCHIVE_AGE = new TaskProperty("ds-task-collect-support-data-retain-previous-support-data-archive-age", TaskMessages.INFO_CSD_DISPLAY_NAME_RETAIN_PREVIOUS_ARCHIVE_AGE.get(), TaskMessages.INFO_CSD_DESCRIPTION_RETAIN_PREVIOUS_ARCHIVE_AGE.get(), String.class, false, false, false);
    @NotNull
    static final TaskProperty PROPERTY_RETAIN_PREVIOUS_ARCHIVE_COUNT = new TaskProperty("ds-task-collect-support-data-retain-previous-support-data-archive-count", TaskMessages.INFO_CSD_DISPLAY_NAME_RETAIN_PREVIOUS_ARCHIVE_COUNT.get(), TaskMessages.INFO_CSD_DESCRIPTION_RETAIN_PREVIOUS_ARCHIVE_COUNT.get(), Long.class, false, false, false);
    @NotNull
    static final TaskProperty PROPERTY_SECURITY_LEVEL = new TaskProperty("ds-task-collect-support-data-security-level", TaskMessages.INFO_CSD_DISPLAY_NAME_SECURITY_LEVEL.get(), TaskMessages.INFO_CSD_DESCRIPTION_SECURITY_LEVEL.get(CollectSupportDataSecurityLevel.NONE.getName(), CollectSupportDataSecurityLevel.OBSCURE_SECRETS.getName(), CollectSupportDataSecurityLevel.MAXIMUM.getName()), String.class, false, false, false, new Object[]{CollectSupportDataSecurityLevel.NONE.getName(), CollectSupportDataSecurityLevel.OBSCURE_SECRETS.getName(), CollectSupportDataSecurityLevel.MAXIMUM.getName()});
    @NotNull
    static final TaskProperty PROPERTY_USE_SEQUENTIAL_MODE = new TaskProperty("ds-task-collect-support-data-use-sequential-mode", TaskMessages.INFO_CSD_DISPLAY_NAME_USE_SEQUENTIAL_MODE.get(), TaskMessages.INFO_CSD_DESCRIPTION_USE_SEQUENTIAL_MODE.get(), Boolean.class, false, false, false);
    private static final long serialVersionUID = -3414981969721886291L;
    @Nullable
    private final Boolean includeBinaryFiles;
    @Nullable
    private final Boolean includeExpensiveData;
    @Nullable
    private final Boolean includeExtensionSource;
    @Nullable
    private final Boolean includeReplicationStateDump;
    @Nullable
    private final Boolean useSequentialMode;
    @Nullable
    private final CollectSupportDataSecurityLevel securityLevel;
    @Nullable
    private final Date logEndTime;
    @Nullable
    private final Date logStartTime;
    @Nullable
    private final Integer jstackCount;
    @Nullable
    private final Integer logFileHeadCollectionSizeKB;
    @Nullable
    private final Integer logFileTailCollectionSizeKB;
    @Nullable
    private final Integer reportCount;
    @Nullable
    private final Integer reportIntervalSeconds;
    @Nullable
    private final Integer retainPreviousSupportDataArchiveCount;
    @Nullable
    private final String comment;
    @Nullable
    private final String encryptionPassphraseFile;
    @Nullable
    private final String logDuration;
    @Nullable
    private final String outputPath;
    @Nullable
    private final String retainPreviousSupportDataArchiveAge;

    public CollectSupportDataTask() {
        this(new CollectSupportDataTaskProperties());
    }

    public CollectSupportDataTask(@NotNull CollectSupportDataTaskProperties properties) {
        super(properties.getTaskID(), COLLECT_SUPPORT_DATA_TASK_CLASS, properties.getScheduledStartTime(), properties.getDependencyIDs(), properties.getFailedDependencyAction(), properties.getNotifyOnStart(), properties.getNotifyOnCompletion(), properties.getNotifyOnSuccess(), properties.getNotifyOnError(), properties.getAlertOnStart(), properties.getAlertOnSuccess(), properties.getAlertOnError());
        this.includeBinaryFiles = properties.getIncludeBinaryFiles();
        this.includeExpensiveData = properties.getIncludeExpensiveData();
        this.includeExtensionSource = properties.getIncludeExtensionSource();
        this.includeReplicationStateDump = properties.getIncludeReplicationStateDump();
        this.useSequentialMode = properties.getUseSequentialMode();
        this.securityLevel = properties.getSecurityLevel();
        this.jstackCount = properties.getJStackCount();
        this.logFileHeadCollectionSizeKB = properties.getLogFileHeadCollectionSizeKB();
        this.logFileTailCollectionSizeKB = properties.getLogFileTailCollectionSizeKB();
        this.reportCount = properties.getReportCount();
        this.reportIntervalSeconds = properties.getReportIntervalSeconds();
        this.retainPreviousSupportDataArchiveCount = properties.getRetainPreviousSupportDataArchiveCount();
        this.comment = properties.getComment();
        this.encryptionPassphraseFile = properties.getEncryptionPassphraseFile();
        this.logStartTime = properties.getLogStartTime();
        this.logEndTime = properties.getLogEndTime();
        this.logDuration = properties.getLogDuration();
        this.outputPath = properties.getOutputPath();
        this.retainPreviousSupportDataArchiveAge = properties.getRetainPreviousSupportDataArchiveAge();
    }

    public CollectSupportDataTask(@NotNull Entry entry) throws TaskException {
        super(entry);
        this.includeBinaryFiles = entry.getAttributeValueAsBoolean(ATTR_INCLUDE_BINARY_FILES);
        this.includeExpensiveData = entry.getAttributeValueAsBoolean(ATTR_INCLUDE_EXPENSIVE_DATA);
        this.includeExtensionSource = entry.getAttributeValueAsBoolean(ATTR_INCLUDE_EXTENSION_SOURCE);
        this.includeReplicationStateDump = entry.getAttributeValueAsBoolean(ATTR_INCLUDE_REPLICATION_STATE_DUMP);
        this.useSequentialMode = entry.getAttributeValueAsBoolean(ATTR_USE_SEQUENTIAL_MODE);
        this.jstackCount = entry.getAttributeValueAsInteger(ATTR_JSTACK_COUNT);
        this.logFileHeadCollectionSizeKB = entry.getAttributeValueAsInteger(ATTR_LOG_FILE_HEAD_COLLECTION_SIZE_KB);
        this.logFileTailCollectionSizeKB = entry.getAttributeValueAsInteger(ATTR_LOG_FILE_TAIL_COLLECTION_SIZE_KB);
        this.reportCount = entry.getAttributeValueAsInteger(ATTR_REPORT_COUNT);
        this.reportIntervalSeconds = entry.getAttributeValueAsInteger(ATTR_REPORT_INTERVAL_SECONDS);
        this.retainPreviousSupportDataArchiveCount = entry.getAttributeValueAsInteger(ATTR_RETAIN_PREVIOUS_ARCHIVE_COUNT);
        this.comment = entry.getAttributeValue(ATTR_COMMENT);
        this.encryptionPassphraseFile = entry.getAttributeValue(ATTR_ENCRYPTION_PASSPHRASE_FILE);
        this.outputPath = entry.getAttributeValue(ATTR_OUTPUT_PATH);
        String securityLevelStr = entry.getAttributeValue(ATTR_SECURITY_LEVEL);
        if (securityLevelStr == null) {
            this.securityLevel = null;
        } else {
            this.securityLevel = CollectSupportDataSecurityLevel.forName(securityLevelStr);
            if (this.securityLevel == null) {
                throw new TaskException(TaskMessages.ERR_CSD_ENTRY_INVALID_SECURITY_LEVEL.get(entry.getDN(), securityLevelStr, ATTR_SECURITY_LEVEL, CollectSupportDataSecurityLevel.NONE.getName(), CollectSupportDataSecurityLevel.OBSCURE_SECRETS.getName(), CollectSupportDataSecurityLevel.MAXIMUM.getName()));
            }
        }
        if (entry.hasAttribute(ATTR_LOG_START_TIME)) {
            this.logStartTime = entry.getAttributeValueAsDate(ATTR_LOG_START_TIME);
            if (this.logStartTime == null) {
                throw new TaskException(TaskMessages.ERR_CSD_ENTRY_INVALID_TIMESTAMP.get(entry.getDN(), entry.getAttributeValue(ATTR_LOG_START_TIME), ATTR_LOG_START_TIME));
            }
        } else {
            this.logStartTime = null;
        }
        if (entry.hasAttribute(ATTR_LOG_END_TIME)) {
            this.logEndTime = entry.getAttributeValueAsDate(ATTR_LOG_END_TIME);
            if (this.logEndTime == null) {
                throw new TaskException(TaskMessages.ERR_CSD_ENTRY_INVALID_TIMESTAMP.get(entry.getDN(), entry.getAttributeValue(ATTR_LOG_END_TIME), ATTR_LOG_END_TIME));
            }
        } else {
            this.logEndTime = null;
        }
        this.logDuration = entry.getAttributeValue(ATTR_LOG_DURATION);
        if (this.logDuration != null) {
            try {
                DurationArgument.parseDuration(this.logDuration, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new TaskException(TaskMessages.ERR_CSD_ENTRY_INVALID_DURATION.get(entry.getDN(), this.logDuration, ATTR_LOG_DURATION), e);
            }
        }
        this.retainPreviousSupportDataArchiveAge = entry.getAttributeValue(ATTR_RETAIN_PREVIOUS_ARCHIVE_AGE);
        if (this.retainPreviousSupportDataArchiveAge != null) {
            try {
                DurationArgument.parseDuration(this.retainPreviousSupportDataArchiveAge, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new TaskException(TaskMessages.ERR_CSD_ENTRY_INVALID_DURATION.get(entry.getDN(), this.retainPreviousSupportDataArchiveAge, ATTR_RETAIN_PREVIOUS_ARCHIVE_AGE), e);
            }
        }
    }

    public CollectSupportDataTask(@NotNull Map<TaskProperty, List<Object>> properties) throws TaskException {
        super(COLLECT_SUPPORT_DATA_TASK_CLASS, properties);
        Boolean includeBinary = null;
        Boolean includeExpensive = null;
        Boolean includeReplicationState = null;
        Boolean includeSource = null;
        Boolean sequentialMode = null;
        CollectSupportDataSecurityLevel secLevel = null;
        Date logEndDate = null;
        Date logStartDate = null;
        Integer logHeadSizeKB = null;
        Integer logTailSizeKB = null;
        Integer numJStacks = null;
        Integer numReports = null;
        Integer reportIntervalSecs = null;
        Integer retainCount = null;
        String commentStr = null;
        String encPWFile = null;
        String logDurationStr = null;
        String outputPathStr = null;
        String retainAge = null;
        for (Map.Entry<TaskProperty, List<Object>> entry : properties.entrySet()) {
            TaskProperty p = entry.getKey();
            String attrName = StaticUtils.toLowerCase(p.getAttributeName());
            List<Object> values = entry.getValue();
            if (attrName.equals(ATTR_INCLUDE_BINARY_FILES)) {
                includeBinary = CollectSupportDataTask.parseBoolean(p, values, includeBinary);
                continue;
            }
            if (attrName.equals(ATTR_INCLUDE_EXPENSIVE_DATA)) {
                includeExpensive = CollectSupportDataTask.parseBoolean(p, values, includeExpensive);
                continue;
            }
            if (attrName.equals(ATTR_INCLUDE_REPLICATION_STATE_DUMP)) {
                includeReplicationState = CollectSupportDataTask.parseBoolean(p, values, includeReplicationState);
                continue;
            }
            if (attrName.equals(ATTR_INCLUDE_EXTENSION_SOURCE)) {
                includeSource = CollectSupportDataTask.parseBoolean(p, values, includeSource);
                continue;
            }
            if (attrName.equals(ATTR_USE_SEQUENTIAL_MODE)) {
                sequentialMode = CollectSupportDataTask.parseBoolean(p, values, sequentialMode);
                continue;
            }
            if (attrName.equals(ATTR_SECURITY_LEVEL)) {
                String secLevelStr = CollectSupportDataTask.parseString(p, values, CollectSupportDataTask.getSecurityLevelName(secLevel));
                secLevel = CollectSupportDataSecurityLevel.forName(secLevelStr);
                continue;
            }
            if (attrName.equals(ATTR_JSTACK_COUNT)) {
                numJStacks = CollectSupportDataTask.parseLong(p, values, CollectSupportDataTask.getIntegerAsLong(numJStacks)).intValue();
                continue;
            }
            if (attrName.equals(ATTR_LOG_FILE_HEAD_COLLECTION_SIZE_KB)) {
                logHeadSizeKB = CollectSupportDataTask.parseLong(p, values, CollectSupportDataTask.getIntegerAsLong(logHeadSizeKB)).intValue();
                continue;
            }
            if (attrName.equals(ATTR_LOG_FILE_TAIL_COLLECTION_SIZE_KB)) {
                logTailSizeKB = CollectSupportDataTask.parseLong(p, values, CollectSupportDataTask.getIntegerAsLong(logTailSizeKB)).intValue();
                continue;
            }
            if (attrName.equals(ATTR_REPORT_COUNT)) {
                numReports = CollectSupportDataTask.parseLong(p, values, CollectSupportDataTask.getIntegerAsLong(numReports)).intValue();
                continue;
            }
            if (attrName.equals(ATTR_REPORT_INTERVAL_SECONDS)) {
                reportIntervalSecs = CollectSupportDataTask.parseLong(p, values, CollectSupportDataTask.getIntegerAsLong(reportIntervalSecs)).intValue();
                continue;
            }
            if (attrName.equals(ATTR_COMMENT)) {
                commentStr = CollectSupportDataTask.parseString(p, values, commentStr);
                continue;
            }
            if (attrName.equals(ATTR_ENCRYPTION_PASSPHRASE_FILE)) {
                encPWFile = CollectSupportDataTask.parseString(p, values, encPWFile);
                continue;
            }
            if (attrName.equals(ATTR_LOG_START_TIME)) {
                logStartDate = CollectSupportDataTask.parseDate(p, values, null);
                continue;
            }
            if (attrName.equals(ATTR_LOG_END_TIME)) {
                logEndDate = CollectSupportDataTask.parseDate(p, values, null);
                continue;
            }
            if (attrName.equals(ATTR_LOG_DURATION)) {
                logDurationStr = CollectSupportDataTask.parseString(p, values, logDurationStr);
                try {
                    DurationArgument.parseDuration(logDurationStr, TimeUnit.MILLISECONDS);
                    continue;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new TaskException(TaskMessages.ERR_CSD_PROPERTY_INVALID_DURATION.get(logDurationStr, ATTR_LOG_DURATION), e);
                }
            }
            if (attrName.equals(ATTR_OUTPUT_PATH)) {
                outputPathStr = CollectSupportDataTask.parseString(p, values, outputPathStr);
                continue;
            }
            if (attrName.equals(ATTR_RETAIN_PREVIOUS_ARCHIVE_COUNT)) {
                retainCount = CollectSupportDataTask.parseLong(p, values, CollectSupportDataTask.getIntegerAsLong(retainCount)).intValue();
                continue;
            }
            if (!attrName.equals(ATTR_RETAIN_PREVIOUS_ARCHIVE_AGE)) continue;
            retainAge = CollectSupportDataTask.parseString(p, values, retainAge);
            try {
                DurationArgument.parseDuration(retainAge, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new TaskException(TaskMessages.ERR_CSD_PROPERTY_INVALID_DURATION.get(retainAge, ATTR_RETAIN_PREVIOUS_ARCHIVE_AGE), e);
            }
        }
        this.includeBinaryFiles = includeBinary;
        this.includeExpensiveData = includeExpensive;
        this.includeReplicationStateDump = includeReplicationState;
        this.includeExtensionSource = includeSource;
        this.useSequentialMode = sequentialMode;
        this.securityLevel = secLevel;
        this.jstackCount = numJStacks;
        this.logFileHeadCollectionSizeKB = logHeadSizeKB;
        this.logFileTailCollectionSizeKB = logTailSizeKB;
        this.reportCount = numReports;
        this.reportIntervalSeconds = reportIntervalSecs;
        this.retainPreviousSupportDataArchiveCount = retainCount;
        this.comment = commentStr;
        this.encryptionPassphraseFile = encPWFile;
        this.logStartTime = logStartDate;
        this.logEndTime = logEndDate;
        this.logDuration = logDurationStr;
        this.outputPath = outputPathStr;
        this.retainPreviousSupportDataArchiveAge = retainAge;
    }

    @Nullable
    static String getSecurityLevelName(@Nullable CollectSupportDataSecurityLevel securityLevel) {
        if (securityLevel == null) {
            return null;
        }
        return securityLevel.getName();
    }

    @Nullable
    static Long getIntegerAsLong(@Nullable Integer i) {
        if (i == null) {
            return null;
        }
        return i.longValue();
    }

    @Override
    @NotNull
    public String getTaskName() {
        return TaskMessages.INFO_CSD_TASK_NAME.get();
    }

    @Override
    @NotNull
    public String getTaskDescription() {
        return TaskMessages.INFO_CSD_TASK_DESCRIPTION.get();
    }

    @Nullable
    public String getOutputPath() {
        return this.outputPath;
    }

    @Nullable
    public String getEncryptionPassphraseFile() {
        return this.encryptionPassphraseFile;
    }

    @Nullable
    public Boolean getIncludeExpensiveData() {
        return this.includeExpensiveData;
    }

    @Nullable
    public Boolean getIncludeReplicationStateDump() {
        return this.includeReplicationStateDump;
    }

    @Nullable
    public Boolean getIncludeBinaryFiles() {
        return this.includeBinaryFiles;
    }

    @Nullable
    public Boolean getIncludeExtensionSource() {
        return this.includeExtensionSource;
    }

    @Nullable
    public Boolean getUseSequentialMode() {
        return this.useSequentialMode;
    }

    @Nullable
    public CollectSupportDataSecurityLevel getSecurityLevel() {
        return this.securityLevel;
    }

    @Nullable
    public Integer getReportCount() {
        return this.reportCount;
    }

    @Nullable
    public Integer getReportIntervalSeconds() {
        return this.reportIntervalSeconds;
    }

    @Nullable
    public Integer getJStackCount() {
        return this.jstackCount;
    }

    @Nullable
    public Date getLogStartTime() {
        return this.logStartTime;
    }

    @Nullable
    public Date getLogEndTime() {
        return this.logEndTime;
    }

    @Nullable
    public String getLogDuration() {
        return this.logDuration;
    }

    @Nullable
    public Integer getLogFileHeadCollectionSizeKB() {
        return this.logFileHeadCollectionSizeKB;
    }

    @Nullable
    public Integer getLogFileTailCollectionSizeKB() {
        return this.logFileTailCollectionSizeKB;
    }

    @Nullable
    public Long getLogDurationMillis() throws TaskException {
        if (this.logDuration == null) {
            return null;
        }
        try {
            return DurationArgument.parseDuration(this.logDuration, TimeUnit.MILLISECONDS);
        }
        catch (ArgumentException e) {
            Debug.debugException(e);
            throw new TaskException(e.getMessage(), e);
        }
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    @Nullable
    public Integer getRetainPreviousSupportDataArchiveCount() {
        return this.retainPreviousSupportDataArchiveCount;
    }

    @Nullable
    public String getRetainPreviousSupportDataArchiveAge() {
        return this.retainPreviousSupportDataArchiveAge;
    }

    @Nullable
    public Long getRetainPreviousSupportDataArchiveAgeMillis() throws TaskException {
        if (this.retainPreviousSupportDataArchiveAge == null) {
            return null;
        }
        try {
            return DurationArgument.parseDuration(this.retainPreviousSupportDataArchiveAge, TimeUnit.MILLISECONDS);
        }
        catch (ArgumentException e) {
            Debug.debugException(e);
            throw new TaskException(e.getMessage(), e);
        }
    }

    @Override
    @NotNull
    protected List<String> getAdditionalObjectClasses() {
        return Collections.singletonList(OC_COLLECT_SUPPORT_DATA_TASK);
    }

    @Override
    @NotNull
    protected List<Attribute> getAdditionalAttributes() {
        ArrayList<Attribute> attrList = new ArrayList<Attribute>(15);
        if (this.outputPath != null) {
            attrList.add(new Attribute(ATTR_OUTPUT_PATH, this.outputPath));
        }
        if (this.encryptionPassphraseFile != null) {
            attrList.add(new Attribute(ATTR_ENCRYPTION_PASSPHRASE_FILE, this.encryptionPassphraseFile));
        }
        if (this.includeExpensiveData != null) {
            attrList.add(new Attribute(ATTR_INCLUDE_EXPENSIVE_DATA, this.includeExpensiveData != false ? "TRUE" : "FALSE"));
        }
        if (this.includeReplicationStateDump != null) {
            attrList.add(new Attribute(ATTR_INCLUDE_REPLICATION_STATE_DUMP, this.includeReplicationStateDump != false ? "TRUE" : "FALSE"));
        }
        if (this.includeBinaryFiles != null) {
            attrList.add(new Attribute(ATTR_INCLUDE_BINARY_FILES, this.includeBinaryFiles != false ? "TRUE" : "FALSE"));
        }
        if (this.includeExtensionSource != null) {
            attrList.add(new Attribute(ATTR_INCLUDE_EXTENSION_SOURCE, this.includeExtensionSource != false ? "TRUE" : "FALSE"));
        }
        if (this.useSequentialMode != null) {
            attrList.add(new Attribute(ATTR_USE_SEQUENTIAL_MODE, this.useSequentialMode != false ? "TRUE" : "FALSE"));
        }
        if (this.securityLevel != null) {
            attrList.add(new Attribute(ATTR_SECURITY_LEVEL, this.securityLevel.getName()));
        }
        if (this.jstackCount != null) {
            attrList.add(new Attribute(ATTR_JSTACK_COUNT, String.valueOf(this.jstackCount)));
        }
        if (this.reportCount != null) {
            attrList.add(new Attribute(ATTR_REPORT_COUNT, String.valueOf(this.reportCount)));
        }
        if (this.reportIntervalSeconds != null) {
            attrList.add(new Attribute(ATTR_REPORT_INTERVAL_SECONDS, String.valueOf(this.reportIntervalSeconds)));
        }
        if (this.logStartTime != null) {
            attrList.add(new Attribute(ATTR_LOG_START_TIME, StaticUtils.encodeGeneralizedTime(this.logStartTime)));
        }
        if (this.logEndTime != null) {
            attrList.add(new Attribute(ATTR_LOG_END_TIME, StaticUtils.encodeGeneralizedTime(this.logEndTime)));
        }
        if (this.logDuration != null) {
            attrList.add(new Attribute(ATTR_LOG_DURATION, this.logDuration));
        }
        if (this.logFileHeadCollectionSizeKB != null) {
            attrList.add(new Attribute(ATTR_LOG_FILE_HEAD_COLLECTION_SIZE_KB, String.valueOf(this.logFileHeadCollectionSizeKB)));
        }
        if (this.logFileTailCollectionSizeKB != null) {
            attrList.add(new Attribute(ATTR_LOG_FILE_TAIL_COLLECTION_SIZE_KB, String.valueOf(this.logFileTailCollectionSizeKB)));
        }
        if (this.comment != null) {
            attrList.add(new Attribute(ATTR_COMMENT, this.comment));
        }
        if (this.retainPreviousSupportDataArchiveCount != null) {
            attrList.add(new Attribute(ATTR_RETAIN_PREVIOUS_ARCHIVE_COUNT, String.valueOf(this.retainPreviousSupportDataArchiveCount)));
        }
        if (this.retainPreviousSupportDataArchiveAge != null) {
            attrList.add(new Attribute(ATTR_RETAIN_PREVIOUS_ARCHIVE_AGE, this.retainPreviousSupportDataArchiveAge));
        }
        return attrList;
    }

    @Override
    @NotNull
    public List<TaskProperty> getTaskSpecificProperties() {
        return Collections.unmodifiableList(Arrays.asList(PROPERTY_OUTPUT_PATH, PROPERTY_ENCRYPTION_PASSPHRASE_FILE, PROPERTY_INCLUDE_EXPENSIVE_DATA, PROPERTY_INCLUDE_REPLICATION_STATE_DUMP, PROPERTY_INCLUDE_BINARY_FILES, PROPERTY_INCLUDE_EXTENSION_SOURCE, PROPERTY_USE_SEQUENTIAL_MODE, PROPERTY_SECURITY_LEVEL, PROPERTY_JSTACK_COUNT, PROPERTY_REPORT_COUNT, PROPERTY_REPORT_INTERVAL_SECONDS, PROPERTY_LOG_START_TIME, PROPERTY_LOG_END_TIME, PROPERTY_LOG_DURATION, PROPERTY_LOG_FILE_HEAD_COLLECTION_SIZE_KB, PROPERTY_LOG_FILE_TAIL_COLLECTION_SIZE_KB, PROPERTY_COMMENT, PROPERTY_RETAIN_PREVIOUS_ARCHIVE_COUNT, PROPERTY_RETAIN_PREVIOUS_ARCHIVE_AGE));
    }

    @Override
    @NotNull
    public Map<TaskProperty, List<Object>> getTaskPropertyValues() {
        LinkedHashMap<TaskProperty, List<Object>> props = new LinkedHashMap<TaskProperty, List<Object>>(StaticUtils.computeMapCapacity(20));
        if (this.outputPath != null) {
            props.put(PROPERTY_OUTPUT_PATH, Collections.singletonList(this.outputPath));
        }
        if (this.encryptionPassphraseFile != null) {
            props.put(PROPERTY_ENCRYPTION_PASSPHRASE_FILE, Collections.singletonList(this.encryptionPassphraseFile));
        }
        if (this.includeExpensiveData != null) {
            props.put(PROPERTY_INCLUDE_EXPENSIVE_DATA, Collections.singletonList(this.includeExpensiveData));
        }
        if (this.includeReplicationStateDump != null) {
            props.put(PROPERTY_INCLUDE_REPLICATION_STATE_DUMP, Collections.singletonList(this.includeReplicationStateDump));
        }
        if (this.includeBinaryFiles != null) {
            props.put(PROPERTY_INCLUDE_BINARY_FILES, Collections.singletonList(this.includeBinaryFiles));
        }
        if (this.includeExtensionSource != null) {
            props.put(PROPERTY_INCLUDE_EXTENSION_SOURCE, Collections.singletonList(this.includeExtensionSource));
        }
        if (this.useSequentialMode != null) {
            props.put(PROPERTY_USE_SEQUENTIAL_MODE, Collections.singletonList(this.useSequentialMode));
        }
        if (this.securityLevel != null) {
            props.put(PROPERTY_SECURITY_LEVEL, Collections.singletonList(this.securityLevel.getName()));
        }
        if (this.jstackCount != null) {
            props.put(PROPERTY_JSTACK_COUNT, Collections.singletonList(this.jstackCount.longValue()));
        }
        if (this.reportCount != null) {
            props.put(PROPERTY_REPORT_COUNT, Collections.singletonList(this.reportCount.longValue()));
        }
        if (this.reportIntervalSeconds != null) {
            props.put(PROPERTY_REPORT_INTERVAL_SECONDS, Collections.singletonList(this.reportIntervalSeconds.longValue()));
        }
        if (this.logStartTime != null) {
            props.put(PROPERTY_LOG_START_TIME, Collections.singletonList(this.logStartTime));
        }
        if (this.logEndTime != null) {
            props.put(PROPERTY_LOG_END_TIME, Collections.singletonList(this.logEndTime));
        }
        if (this.logDuration != null) {
            props.put(PROPERTY_LOG_DURATION, Collections.singletonList(this.logDuration));
        }
        if (this.logFileHeadCollectionSizeKB != null) {
            props.put(PROPERTY_LOG_FILE_HEAD_COLLECTION_SIZE_KB, Collections.singletonList(this.logFileHeadCollectionSizeKB.longValue()));
        }
        if (this.logFileTailCollectionSizeKB != null) {
            props.put(PROPERTY_LOG_FILE_TAIL_COLLECTION_SIZE_KB, Collections.singletonList(this.logFileTailCollectionSizeKB.longValue()));
        }
        if (this.comment != null) {
            props.put(PROPERTY_COMMENT, Collections.singletonList(this.comment));
        }
        if (this.retainPreviousSupportDataArchiveCount != null) {
            props.put(PROPERTY_RETAIN_PREVIOUS_ARCHIVE_COUNT, Collections.singletonList(this.retainPreviousSupportDataArchiveCount.longValue()));
        }
        if (this.retainPreviousSupportDataArchiveAge != null) {
            props.put(PROPERTY_RETAIN_PREVIOUS_ARCHIVE_AGE, Collections.singletonList(this.retainPreviousSupportDataArchiveAge));
        }
        props.putAll(super.getTaskPropertyValues());
        return Collections.unmodifiableMap(props);
    }
}

