/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres.mail;

import com.google.common.io.ByteSource;
import jakarta.mail.Flags;
import java.io.IOException;
import java.io.InputStream;
import java.time.Clock;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.backends.postgres.utils.PostgresUtils;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.mailbox.ApplicableFlagBuilder;
import org.apache.james.mailbox.FlagsBuilder;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxCounters;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.postgres.PostgresMailboxId;
import org.apache.james.mailbox.postgres.mail.PostgresAttachmentMapper;
import org.apache.james.mailbox.postgres.mail.PostgresMessageRetriever;
import org.apache.james.mailbox.postgres.mail.PostgresModSeqProvider;
import org.apache.james.mailbox.postgres.mail.PostgresUidProvider;
import org.apache.james.mailbox.postgres.mail.dao.PostgresAttachmentDAO;
import org.apache.james.mailbox.postgres.mail.dao.PostgresMailboxDAO;
import org.apache.james.mailbox.postgres.mail.dao.PostgresMailboxMessageDAO;
import org.apache.james.mailbox.postgres.mail.dao.PostgresMessageDAO;
import org.apache.james.mailbox.store.FlagsUpdateCalculator;
import org.apache.james.mailbox.store.MailboxReactorUtils;
import org.apache.james.mailbox.store.mail.AttachmentIdAssignationStrategy;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailboxMessage;
import org.apache.james.util.streams.Limit;
import org.jooq.Record;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresMessageMapper
implements MessageMapper {
    private static final Function<MailboxMessage, ByteSource> MESSAGE_BODY_CONTENT_LOADER = mailboxMessage -> new ByteSource((MailboxMessage)mailboxMessage){
        final /* synthetic */ MailboxMessage val$mailboxMessage;
        {
            this.val$mailboxMessage = mailboxMessage;
        }

        public InputStream openStream() {
            try {
                return this.val$mailboxMessage.getBodyContent();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public long size() {
            return this.val$mailboxMessage.getBodyOctets();
        }
    };
    private final PostgresMessageDAO messageDAO;
    private final PostgresMailboxMessageDAO mailboxMessageDAO;
    private final PostgresMailboxDAO mailboxDAO;
    private final PostgresModSeqProvider modSeqProvider;
    private final PostgresUidProvider uidProvider;
    private final BlobStore blobStore;
    private final Clock clock;
    private final PostgresMessageRetriever messageRetriever;

    public PostgresMessageMapper(PostgresExecutor postgresExecutor, PostgresModSeqProvider modSeqProvider, PostgresUidProvider uidProvider, BlobStore blobStore, Clock clock, BlobId.Factory blobIdFactory, AttachmentIdAssignationStrategy attachmentIdAssignationStrategy) {
        this.messageDAO = new PostgresMessageDAO(postgresExecutor, blobIdFactory);
        this.mailboxMessageDAO = new PostgresMailboxMessageDAO(postgresExecutor);
        this.mailboxDAO = new PostgresMailboxDAO(postgresExecutor);
        this.modSeqProvider = modSeqProvider;
        this.uidProvider = uidProvider;
        this.blobStore = blobStore;
        this.clock = clock;
        PostgresAttachmentMapper attachmentMapper = new PostgresAttachmentMapper(new PostgresAttachmentDAO(postgresExecutor, blobIdFactory), blobStore, attachmentIdAssignationStrategy);
        this.messageRetriever = new PostgresMessageRetriever(blobStore, blobIdFactory, attachmentMapper);
    }

    public Iterator<MailboxMessage> findInMailbox(Mailbox mailbox, MessageRange set, MessageMapper.FetchType type, int limit) {
        return this.findInMailboxReactive(mailbox, set, type, limit).toIterable().iterator();
    }

    public Flux<ComposedMessageIdWithMetaData> listMessagesMetadata(Mailbox mailbox, MessageRange set) {
        return this.mailboxMessageDAO.findMessagesMetadata((PostgresMailboxId)mailbox.getMailboxId(), set);
    }

    public Flux<MailboxMessage> findInMailboxReactive(Mailbox mailbox, MessageRange messageRange, MessageMapper.FetchType fetchType, int limitAsInt) {
        Flux<Pair<SimpleMailboxMessage.Builder, Record>> fetchMessagePublisher = this.fetchMessageWithoutFullContent(mailbox, messageRange, fetchType, limitAsInt);
        return this.messageRetriever.get(fetchType, fetchMessagePublisher);
    }

    private Flux<Pair<SimpleMailboxMessage.Builder, Record>> fetchMessageWithoutFullContent(Mailbox mailbox, MessageRange messageRange, MessageMapper.FetchType fetchType, int limitAsInt) {
        return Mono.just((Object)messageRange).flatMapMany(range -> {
            Limit limit = Limit.from((int)limitAsInt);
            switch (messageRange.getType()) {
                case ALL: {
                    return this.mailboxMessageDAO.findMessagesByMailboxId((PostgresMailboxId)mailbox.getMailboxId(), limit, fetchType);
                }
                case FROM: {
                    return this.mailboxMessageDAO.findMessagesByMailboxIdAndAfterUID((PostgresMailboxId)mailbox.getMailboxId(), range.getUidFrom(), limit, fetchType);
                }
                case ONE: {
                    return this.mailboxMessageDAO.findMessageByMailboxIdAndUid((PostgresMailboxId)mailbox.getMailboxId(), range.getUidFrom(), fetchType).flatMapMany(Flux::just);
                }
                case RANGE: {
                    return this.mailboxMessageDAO.findMessagesByMailboxIdAndBetweenUIDs((PostgresMailboxId)mailbox.getMailboxId(), range.getUidFrom(), range.getUidTo(), limit, fetchType);
                }
            }
            throw new RuntimeException("Unknown MessageRange range " + String.valueOf(range.getType()));
        });
    }

    public List<MessageUid> retrieveMessagesMarkedForDeletion(Mailbox mailbox, MessageRange messageRange) {
        return (List)this.retrieveMessagesMarkedForDeletionReactive(mailbox, messageRange).collectList().block();
    }

    public Flux<MessageUid> retrieveMessagesMarkedForDeletionReactive(Mailbox mailbox, MessageRange messageRange) {
        return Mono.just((Object)messageRange).flatMapMany(range -> {
            switch (messageRange.getType()) {
                case ALL: {
                    return this.mailboxMessageDAO.findDeletedMessagesByMailboxId((PostgresMailboxId)mailbox.getMailboxId());
                }
                case FROM: {
                    return this.mailboxMessageDAO.findDeletedMessagesByMailboxIdAndAfterUID((PostgresMailboxId)mailbox.getMailboxId(), range.getUidFrom());
                }
                case ONE: {
                    return this.mailboxMessageDAO.findDeletedMessageByMailboxIdAndUid((PostgresMailboxId)mailbox.getMailboxId(), range.getUidFrom()).flatMapMany(Flux::just);
                }
                case RANGE: {
                    return this.mailboxMessageDAO.findDeletedMessagesByMailboxIdAndBetweenUIDs((PostgresMailboxId)mailbox.getMailboxId(), range.getUidFrom(), range.getUidTo());
                }
            }
            throw new RuntimeException("Unknown MessageRange type " + String.valueOf(range.getType()));
        });
    }

    public long countMessagesInMailbox(Mailbox mailbox) {
        return ((Integer)this.mailboxMessageDAO.countTotalMessagesByMailboxId((PostgresMailboxId)mailbox.getMailboxId()).block()).intValue();
    }

    public MailboxCounters getMailboxCounters(Mailbox mailbox) {
        return (MailboxCounters)this.getMailboxCountersReactive(mailbox).block();
    }

    public Mono<MailboxCounters> getMailboxCountersReactive(Mailbox mailbox) {
        return this.mailboxMessageDAO.countTotalAndUnseenMessagesByMailboxId((PostgresMailboxId)mailbox.getMailboxId()).map(pair -> MailboxCounters.builder().mailboxId(mailbox.getMailboxId()).count((long)((Integer)pair.getLeft()).intValue()).unseen((long)((Integer)pair.getRight()).intValue()).build());
    }

    public void delete(Mailbox mailbox, MailboxMessage message) throws MailboxException {
        this.deleteMessages(mailbox, List.of(message.getUid()));
    }

    public Map<MessageUid, MessageMetaData> deleteMessages(Mailbox mailbox, List<MessageUid> uids) {
        return (Map)this.deleteMessagesReactive(mailbox, uids).block();
    }

    public Mono<Map<MessageUid, MessageMetaData>> deleteMessagesReactive(Mailbox mailbox, List<MessageUid> uids) {
        return this.mailboxMessageDAO.findMessagesByMailboxIdAndUIDs((PostgresMailboxId)mailbox.getMailboxId(), uids).map(SimpleMailboxMessage.Builder::build).collectMap(MailboxMessage::getUid, MailboxMessage::metaData).flatMap(map -> this.mailboxMessageDAO.deleteByMailboxIdAndMessageUids((PostgresMailboxId)mailbox.getMailboxId(), uids).then(Mono.just((Object)map)));
    }

    public MessageUid findFirstUnseenMessageUid(Mailbox mailbox) {
        return (MessageUid)this.mailboxMessageDAO.findFirstUnseenMessageUid((PostgresMailboxId)mailbox.getMailboxId()).block();
    }

    public Mono<Optional<MessageUid>> findFirstUnseenMessageUidReactive(Mailbox mailbox) {
        return this.mailboxMessageDAO.findFirstUnseenMessageUid((PostgresMailboxId)mailbox.getMailboxId()).map(Optional::of).switchIfEmpty(Mono.just(Optional.empty()));
    }

    public List<MessageUid> findRecentMessageUidsInMailbox(Mailbox mailbox) {
        return (List)this.findRecentMessageUidsInMailboxReactive(mailbox).block();
    }

    public Mono<List<MessageUid>> findRecentMessageUidsInMailboxReactive(Mailbox mailbox) {
        return this.mailboxMessageDAO.findAllRecentMessageUid((PostgresMailboxId)mailbox.getMailboxId()).collectList();
    }

    public MessageMetaData add(Mailbox mailbox, MailboxMessage message) throws MailboxException {
        return (MessageMetaData)this.addReactive(mailbox, message).block();
    }

    public Mono<MessageMetaData> addReactive(Mailbox mailbox, MailboxMessage message) {
        return Mono.fromCallable(() -> {
            message.setSaveDate(Date.from(this.clock.instant()));
            return message;
        }).flatMap(this::setNewUidAndModSeq).then(this.saveBodyContent(message).flatMap(bodyBlobId -> this.messageDAO.insert(message, bodyBlobId.asString()).onErrorResume(PostgresUtils.UNIQUE_CONSTRAINT_VIOLATION_PREDICATE, e -> Mono.empty()))).then(Mono.defer(() -> this.mailboxMessageDAO.insert(message))).then(Mono.fromCallable(() -> ((MailboxMessage)message).metaData()));
    }

    private Mono<BlobId> saveBodyContent(MailboxMessage message) {
        return Mono.fromCallable(() -> MESSAGE_BODY_CONTENT_LOADER.apply(message)).flatMap(bodyByteSource -> Mono.from((Publisher)this.blobStore.save(this.blobStore.getDefaultBucketName(), bodyByteSource, BlobStore.StoragePolicy.LOW_COST)));
    }

    public Iterator<UpdatedFlags> updateFlags(Mailbox mailbox, FlagsUpdateCalculator flagsUpdateCalculator, MessageRange range) {
        return this.updateFlagsPublisher(mailbox, flagsUpdateCalculator, range).toIterable().iterator();
    }

    public Mono<List<UpdatedFlags>> updateFlagsReactive(Mailbox mailbox, FlagsUpdateCalculator flagsUpdateCalculator, MessageRange range) {
        return this.updateFlagsPublisher(mailbox, flagsUpdateCalculator, range).collectList();
    }

    private Flux<UpdatedFlags> updateFlagsPublisher(Mailbox mailbox, FlagsUpdateCalculator flagsUpdateCalculator, MessageRange range) {
        return this.mailboxMessageDAO.findMessagesMetadata((PostgresMailboxId)mailbox.getMailboxId(), range).collectList().flatMapMany(listMessagesMetadata -> this.updatedFlags((List<ComposedMessageIdWithMetaData>)listMessagesMetadata, mailbox, flagsUpdateCalculator));
    }

    private Flux<UpdatedFlags> updatedFlags(List<ComposedMessageIdWithMetaData> listMessagesMetaData, Mailbox mailbox, FlagsUpdateCalculator flagsUpdateCalculator) {
        return this.modSeqProvider.nextModSeqReactive(mailbox.getMailboxId()).flatMapMany(newModSeq -> Flux.fromIterable((Iterable)listMessagesMetaData).flatMapSequential(messageMetaData -> this.updateFlags((ComposedMessageIdWithMetaData)messageMetaData, flagsUpdateCalculator, (ModSeq)newModSeq), 16));
    }

    private Mono<UpdatedFlags> updateFlags(ComposedMessageIdWithMetaData currentMetaData, FlagsUpdateCalculator flagsUpdateCalculator, ModSeq newModSeq) {
        Flags oldFlags = currentMetaData.getFlags();
        ComposedMessageId composedMessageId = currentMetaData.getComposedMessageId();
        if (oldFlags.equals((Object)flagsUpdateCalculator.buildNewFlags(oldFlags))) {
            return Mono.just((Object)UpdatedFlags.builder().messageId(composedMessageId.getMessageId()).oldFlags(oldFlags).newFlags(oldFlags).uid(composedMessageId.getUid()).modSeq(currentMetaData.getModSeq()).build());
        }
        return Mono.just((Object)flagsUpdateCalculator.getMode()).flatMap(mode -> {
            switch (mode) {
                case ADD: {
                    return this.mailboxMessageDAO.addFlags((PostgresMailboxId)composedMessageId.getMailboxId(), composedMessageId.getUid(), flagsUpdateCalculator.providedFlags(), newModSeq);
                }
                case REMOVE: {
                    return this.mailboxMessageDAO.removeFlags((PostgresMailboxId)composedMessageId.getMailboxId(), composedMessageId.getUid(), flagsUpdateCalculator.providedFlags(), newModSeq);
                }
                case REPLACE: {
                    return this.mailboxMessageDAO.replaceFlags((PostgresMailboxId)composedMessageId.getMailboxId(), composedMessageId.getUid(), flagsUpdateCalculator.providedFlags(), newModSeq);
                }
            }
            return Mono.error(() -> new RuntimeException("Unknown MessageRange type " + String.valueOf(mode)));
        }).map(updatedFlags -> UpdatedFlags.builder().messageId(composedMessageId.getMessageId()).oldFlags(oldFlags).newFlags(updatedFlags).uid(composedMessageId.getUid()).modSeq(newModSeq).build());
    }

    public List<UpdatedFlags> resetRecent(Mailbox mailbox) {
        return (List)this.resetRecentReactive(mailbox).block();
    }

    public Mono<List<UpdatedFlags>> resetRecentReactive(Mailbox mailbox) {
        return this.mailboxMessageDAO.findAllRecentMessageMetadata((PostgresMailboxId)mailbox.getMailboxId()).collectList().flatMapMany(mailboxMessageList -> this.resetRecentFlag((PostgresMailboxId)mailbox.getMailboxId(), (List<ComposedMessageIdWithMetaData>)mailboxMessageList)).collectList();
    }

    private Flux<UpdatedFlags> resetRecentFlag(PostgresMailboxId mailboxId, List<ComposedMessageIdWithMetaData> messageIdWithMetaDataList) {
        return Flux.fromIterable(messageIdWithMetaDataList).collectMap(m -> m.getComposedMessageId().getUid(), Function.identity()).flatMapMany(uidMapping -> this.modSeqProvider.nextModSeqReactive(mailboxId).flatMapMany(newModSeq -> this.mailboxMessageDAO.resetRecentFlag(mailboxId, List.copyOf(uidMapping.keySet()), (ModSeq)newModSeq)).map(newMetaData -> UpdatedFlags.builder().messageId(newMetaData.getMessageId()).modSeq(newMetaData.getModSeq()).oldFlags(((ComposedMessageIdWithMetaData)uidMapping.get(newMetaData.getUid())).getFlags()).newFlags(newMetaData.getFlags()).uid(newMetaData.getUid()).build()));
    }

    public MessageMetaData copy(Mailbox mailbox, MailboxMessage original) throws MailboxException {
        return (MessageMetaData)this.copyReactive(mailbox, original).block();
    }

    private Mono<Void> setNewUidAndModSeq(MailboxMessage mailboxMessage) {
        return this.mailboxDAO.incrementAndGetLastUidAndModSeq(mailboxMessage.getMailboxId()).defaultIfEmpty((Object)Pair.of((Object)MessageUid.MIN_VALUE, (Object)ModSeq.first())).map(pair -> {
            mailboxMessage.setUid((MessageUid)pair.getLeft());
            mailboxMessage.setModSeq((ModSeq)pair.getRight());
            return pair;
        }).then();
    }

    public Mono<MessageMetaData> copyReactive(Mailbox mailbox, MailboxMessage original) {
        return Mono.fromCallable(() -> {
            MailboxMessage copiedMessage = original.copy(mailbox);
            copiedMessage.setFlags(new FlagsBuilder().add(new Flags[]{original.createFlags()}).add(new Flags.Flag[]{Flags.Flag.RECENT}).build());
            copiedMessage.setSaveDate(Date.from(this.clock.instant()));
            return copiedMessage;
        }).flatMap(copiedMessage -> this.setNewUidAndModSeq((MailboxMessage)copiedMessage).then(Mono.defer(() -> this.mailboxMessageDAO.insert((MailboxMessage)copiedMessage)).thenReturn(copiedMessage)).map(MailboxMessage::metaData));
    }

    public MessageMetaData move(Mailbox mailbox, MailboxMessage original) {
        return (MessageMetaData)this.moveReactive(mailbox, original).block();
    }

    public List<MessageMetaData> move(Mailbox mailbox, List<MailboxMessage> original) throws MailboxException {
        return (List)MailboxReactorUtils.block((Mono)this.moveReactive(mailbox, original));
    }

    public Mono<MessageMetaData> moveReactive(Mailbox mailbox, MailboxMessage original) {
        return this.copyReactive(mailbox, original).flatMap(copiedResult -> this.mailboxMessageDAO.deleteByMailboxIdAndMessageUid((PostgresMailboxId)original.getMailboxId(), original.getUid()).thenReturn(copiedResult));
    }

    public Optional<MessageUid> getLastUid(Mailbox mailbox) {
        return this.uidProvider.lastUid(mailbox);
    }

    public Mono<Optional<MessageUid>> getLastUidReactive(Mailbox mailbox) {
        return this.uidProvider.lastUidReactive(mailbox);
    }

    public ModSeq getHighestModSeq(Mailbox mailbox) {
        return this.modSeqProvider.highestModSeq(mailbox);
    }

    public Mono<ModSeq> getHighestModSeqReactive(Mailbox mailbox) {
        return this.modSeqProvider.highestModSeqReactive(mailbox);
    }

    public Flags getApplicableFlag(Mailbox mailbox) {
        return (Flags)this.getApplicableFlagReactive(mailbox).block();
    }

    public Mono<Flags> getApplicableFlagReactive(Mailbox mailbox) {
        return this.mailboxMessageDAO.listDistinctUserFlags((PostgresMailboxId)mailbox.getMailboxId()).map(flags -> ApplicableFlagBuilder.builder().add(new Flags[]{flags}).build());
    }

    public Flux<MessageUid> listAllMessageUids(Mailbox mailbox) {
        return this.mailboxMessageDAO.listAllMessageUid((PostgresMailboxId)mailbox.getMailboxId());
    }
}

