/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.ConnectHandler;
import org.apache.james.protocols.pop3.POP3Response;
import org.apache.james.protocols.pop3.POP3Session;

public class WelcomeMessageHandler
implements ConnectHandler<POP3Session> {
    public Response onConnect(POP3Session session) {
        StringBuilder responseBuffer = new StringBuilder();
        responseBuffer.append("<").append(session.getSessionID()).append(".").append(System.currentTimeMillis()).append("@").append(session.getConfiguration().getHelloName()).append("> ");
        session.setAttachment(POP3Session.APOP_TIMESTAMP, responseBuffer.toString(), ProtocolSession.State.Connection);
        responseBuffer.append("POP3 server (").append(session.getConfiguration().getSoftwareName()).append(") ready ");
        return new POP3Response("+OK", responseBuffer.toString());
    }
}

