/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.priority;

import java.util.Optional;
import org.apache.james.core.Username;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.protocols.smtp.hook.MailParametersHook;
import org.apache.james.smtpserver.priority.SmtpMtPriorityParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmtpMtPriorityParameterHook
implements MailParametersHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmtpMtPriorityParameterHook.class);
    public static final ProtocolSession.AttachmentKey<Integer> MT_PRIORITY_ATTACHMENT_KEY = ProtocolSession.AttachmentKey.of((String)"MT-PRIORITY", Integer.class);

    public HookResult doMailParameter(SMTPSession session, String paramName, String paramValue) {
        if (session.getAttachment(MT_PRIORITY_ATTACHMENT_KEY, ProtocolSession.State.Transaction).isPresent()) {
            LOGGER.debug("The Mail parameter cannot contain more than one MT-PRIORITY parameter at the same time");
            return HookResult.builder().smtpReturnCode("501").hookReturnCode(HookReturnCode.deny()).smtpDescription("The Mail parameter cannot contain more than one MT-PRIORITY parameter at the same time").build();
        }
        if (paramName.equals("MT-PRIORITY")) {
            try {
                SmtpMtPriorityParameters.MtPriority mtPriority = new SmtpMtPriorityParameters.MtPriority(paramValue);
                if (session.isUnAuthorized(mtPriority.getPriorityValue())) {
                    LOGGER.debug("Needs to be logged to use positive priorities");
                    int mtPriorityValue = SmtpMtPriorityParameters.MtPriority.defaultPriorityValue();
                    session.setAttachment(MT_PRIORITY_ATTACHMENT_KEY, (Object)mtPriorityValue, ProtocolSession.State.Transaction);
                    LOGGER.info("SMTP sessionID: {}, MT-PRIORITY={}", (Object)session.getSessionID(), (Object)mtPriorityValue);
                    return HookResult.DECLINED;
                }
                session.setAttachment(MT_PRIORITY_ATTACHMENT_KEY, (Object)mtPriority.getPriorityValue(), ProtocolSession.State.Transaction);
                String userName = Optional.ofNullable(session.getUsername()).map(Username::asString).orElse("unauthorized");
                LOGGER.info("SMTP sessionID: {}, User: {}, MT-PRIORITY={}", new Object[]{session.getSessionID(), userName, mtPriority.getPriorityValue()});
            }
            catch (IllegalArgumentException e) {
                LOGGER.debug("Incorrect syntax when handling MT-PRIORITY mail parameter", (Throwable)e);
                return HookResult.builder().smtpReturnCode("501").hookReturnCode(HookReturnCode.deny()).smtpDescription("Incorrect syntax when handling MT-PRIORITY mail parameter").build();
            }
        }
        return HookResult.DECLINED;
    }

    public String[] getMailParamNames() {
        return new String[]{"MT-PRIORITY"};
    }
}

