/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.api.spi;

import java.nio.file.ProviderNotFoundException;
import java.util.Properties;
import java.util.ServiceLoader;
import javax.servlet.ServletContext;
import org.apache.wiki.api.spi.AclsDSL;
import org.apache.wiki.api.spi.AclsSPI;
import org.apache.wiki.api.spi.ContentsDSL;
import org.apache.wiki.api.spi.ContentsSPI;
import org.apache.wiki.api.spi.ContextDSL;
import org.apache.wiki.api.spi.ContextSPI;
import org.apache.wiki.api.spi.EngineDSL;
import org.apache.wiki.api.spi.EngineSPI;
import org.apache.wiki.api.spi.SessionDSL;
import org.apache.wiki.api.spi.SessionSPI;
import org.apache.wiki.util.PropertyReader;
import org.apache.wiki.util.TextUtil;

public class Wiki {
    private static final String PROP_PROVIDER_IMPL_ACLS = "jspwiki.provider.impl.acls";
    private static final String PROP_PROVIDER_IMPL_CONTENTS = "jspwiki.provider.impl.contents";
    private static final String PROP_PROVIDER_IMPL_CONTEXT = "jspwiki.provider.impl.context";
    private static final String PROP_PROVIDER_IMPL_ENGINE = "jspwiki.provider.impl.engine";
    private static final String PROP_PROVIDER_IMPL_SESSION = "jspwiki.provider.impl.session";
    private static final String DEFAULT_PROVIDER_IMPL_ACLS = "org.apache.wiki.spi.AclsSPIDefaultImpl";
    private static final String DEFAULT_PROVIDER_IMPL_CONTENTS = "org.apache.wiki.spi.ContentsSPIDefaultImpl";
    private static final String DEFAULT_PROVIDER_IMPL_CONTEXT = "org.apache.wiki.spi.ContextSPIDefaultImpl";
    private static final String DEFAULT_PROVIDER_IMPL_ENGINE = "org.apache.wiki.spi.EngineSPIDefaultImpl";
    private static final String DEFAULT_PROVIDER_IMPL_SESSION = "org.apache.wiki.spi.SessionSPIDefaultImpl";
    private static Properties properties = PropertyReader.getDefaultProperties();
    private static AclsSPI aclsSPI = Wiki.getSPI(AclsSPI.class, properties, "jspwiki.provider.impl.acls", "org.apache.wiki.spi.AclsSPIDefaultImpl");
    private static ContentsSPI contentsSPI = Wiki.getSPI(ContentsSPI.class, properties, "jspwiki.provider.impl.contents", "org.apache.wiki.spi.ContentsSPIDefaultImpl");
    private static ContextSPI contextSPI = Wiki.getSPI(ContextSPI.class, properties, "jspwiki.provider.impl.context", "org.apache.wiki.spi.ContextSPIDefaultImpl");
    private static EngineSPI engineSPI = Wiki.getSPI(EngineSPI.class, properties, "jspwiki.provider.impl.engine", "org.apache.wiki.spi.EngineSPIDefaultImpl");
    private static SessionSPI sessionSPI = Wiki.getSPI(SessionSPI.class, properties, "jspwiki.provider.impl.session", "org.apache.wiki.spi.SessionSPIDefaultImpl");

    public static Properties init(ServletContext context) {
        properties = PropertyReader.loadWebAppProps((ServletContext)context);
        aclsSPI = Wiki.getSPI(AclsSPI.class, properties, PROP_PROVIDER_IMPL_ACLS, DEFAULT_PROVIDER_IMPL_ACLS);
        contentsSPI = Wiki.getSPI(ContentsSPI.class, properties, PROP_PROVIDER_IMPL_CONTENTS, DEFAULT_PROVIDER_IMPL_CONTENTS);
        contextSPI = Wiki.getSPI(ContextSPI.class, properties, PROP_PROVIDER_IMPL_CONTEXT, DEFAULT_PROVIDER_IMPL_CONTEXT);
        engineSPI = Wiki.getSPI(EngineSPI.class, properties, PROP_PROVIDER_IMPL_ENGINE, DEFAULT_PROVIDER_IMPL_ENGINE);
        sessionSPI = Wiki.getSPI(SessionSPI.class, properties, PROP_PROVIDER_IMPL_SESSION, DEFAULT_PROVIDER_IMPL_SESSION);
        return properties;
    }

    public static AclsDSL acls() {
        return new AclsDSL(aclsSPI);
    }

    public static ContentsDSL contents() {
        return new ContentsDSL(contentsSPI);
    }

    public static ContextDSL context() {
        return new ContextDSL(contextSPI);
    }

    public static EngineDSL engine() {
        return new EngineDSL(engineSPI);
    }

    public static SessionDSL session() {
        return new SessionDSL(sessionSPI);
    }

    static <SPI> SPI getSPI(Class<SPI> spi, Properties props, String prop, String defValue) {
        String providerImpl = TextUtil.getStringProperty((Properties)props, (String)prop, (String)defValue);
        ServiceLoader<SPI> loader = ServiceLoader.load(spi);
        for (SPI provider : loader) {
            if (!providerImpl.equals(provider.getClass().getName())) continue;
            return provider;
        }
        throw new ProviderNotFoundException(spi.getName() + " provider not found");
    }
}

