/*
 * Decompiled with CFR 0.152.
 */
package org.intabulas.sandler.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SandlerUtilities {
    public static final String RFC_822_DATE_FORMAT = "EEE, d MMM yyyy kk:mm:ss Z";
    public static final String UTC_DATE_FORMAT = "yyyy-MM-dd'T'kk:mm:ss'Z'";
    private static final ThreadLocal UTC_DATE_FORMAT_OBJECT = new ThreadLocal(){

        protected Object initialValue() {
            return new SimpleDateFormat(SandlerUtilities.UTC_DATE_FORMAT);
        }
    };

    private SandlerUtilities() {
    }

    public static String getUTCDate(Date date) {
        String utcDate = ((SimpleDateFormat)UTC_DATE_FORMAT_OBJECT.get()).format(date).replaceAll("GMT", "");
        return utcDate;
    }

    public static Date getDateFromUTCDate(String date) throws ParseException {
        return ((SimpleDateFormat)UTC_DATE_FORMAT_OBJECT.get()).parse(date);
    }

    public static String downloadUrl(String url) {
        String result = null;
        try {
            int n;
            URL downloadUrl = new URL(url);
            HttpURLConnection http = (HttpURLConnection)downloadUrl.openConnection();
            http.setRequestProperty("User-Agent", "Sandler/0.5 ");
            BufferedInputStream in = new BufferedInputStream(http.getInputStream());
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((n = in.read(buffer, 0, 4096)) >= 0) {
                os.write(buffer, 0, n);
            }
            os.close();
            in.close();
            http.disconnect();
            result = os.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }
}

