/*
 * Decompiled with CFR 0.152.
 */
package com.example.providers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiPage;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.attachment.Attachment;
import org.apache.wiki.pages.PageTimeComparator;
import org.apache.wiki.providers.WikiAttachmentProvider;
import org.apache.wiki.search.QueryItem;

public class TwoXWikiAttachmentProvider
implements WikiAttachmentProvider {
    WikiEngine engine;
    Map<String, List<Attachment>> attachments = new ConcurrentHashMap<String, List<Attachment>>();
    Map<String, List<InputStream>> contents = new ConcurrentHashMap<String, List<InputStream>>();

    public String getProviderInfo() {
        return this.getClass().getName();
    }

    public void initialize(WikiEngine engine, Properties properties) throws NoRequiredPropertyException, IOException {
        this.engine = engine;
        try {
            this.putAttachmentData(new Attachment(engine, "page1", "att11.txt"), new ByteArrayInputStream("blurb".getBytes(StandardCharsets.UTF_8)));
            this.putAttachmentData(new Attachment(engine, "page1", "att12.txt"), new ByteArrayInputStream("blerb".getBytes(StandardCharsets.UTF_8)));
            this.putAttachmentData(new Attachment(engine, "page2", "att21.txt"), new ByteArrayInputStream("blarb".getBytes(StandardCharsets.UTF_8)));
        }
        catch (ProviderException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public void putAttachmentData(Attachment att, InputStream data) throws ProviderException, IOException {
        att.setVersion(att.getVersion() + 1);
        att.setLastModified(new Date());
        if (this.attachmentExists(att)) {
            this.attachments.get(att.getName()).add(att);
            this.contents.get(att.getName()).add(data);
        } else {
            this.attachments.put(att.getName(), new ArrayList<Attachment>(Arrays.asList(att)));
            this.contents.put(att.getName(), new ArrayList<InputStream>(Arrays.asList(data)));
        }
    }

    public InputStream getAttachmentData(Attachment att) throws ProviderException, IOException {
        int v = att.getVersion() == -1 ? this.contents.get(att.getName()).size() - 1 : att.getVersion();
        return this.contents.get(att.getName()).get(v);
    }

    public List<Attachment> listAttachments(WikiPage page) throws ProviderException {
        return this.attachments.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(page.getName() + "/")).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Collection<Attachment> findAttachments(QueryItem[] query) {
        return new ArrayList<Attachment>();
    }

    public List<Attachment> listAllChanged(Date timestamp) throws ProviderException {
        List<Attachment> attachs = this.attachments.values().stream().map(attrs -> (Attachment)attrs.get(attrs.size() - 1)).filter(att -> att.getLastModified() != null && att.getLastModified().after(timestamp)).collect(Collectors.toList());
        attachs.sort((Comparator<Attachment>)new PageTimeComparator());
        return attachs;
    }

    public Attachment getAttachmentInfo(WikiPage page, String name, int version) throws ProviderException {
        if (this.attachments.get(page.getName() + "/" + name) != null) {
            int v = version == -1 ? this.contents.get(page.getName() + "/" + name).size() - 1 : version;
            return this.attachments.get(page.getName() + "/" + name).get(v);
        }
        return null;
    }

    public List<Attachment> getVersionHistory(Attachment att) {
        if (att != null && this.attachments.get(att.getName()) != null) {
            return this.attachments.get(att.getName());
        }
        return Collections.emptyList();
    }

    public void deleteVersion(Attachment att) throws ProviderException {
        if (this.attachmentVersionExists(att)) {
            this.attachments.get(att.getName()).remove(att.getVersion() - 1);
            this.contents.get(att.getName()).remove(att.getVersion() - 1);
        }
    }

    public void deleteAttachment(Attachment att) throws ProviderException {
        if (att != null) {
            this.attachments.remove(att.getName());
            this.contents.remove(att.getName());
        }
    }

    public void moveAttachmentsForPage(String oldParent, String newParent) throws ProviderException {
        Map<String, List> oldAttachments = this.attachments.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(oldParent + "/")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, List> oldContents = this.contents.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(oldParent + "/")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        oldAttachments.forEach((key, value) -> {
            String newKey = newParent + "/" + key.substring(key.indexOf(47) + 1);
            this.attachments.putIfAbsent(newKey, (List<Attachment>)value);
            if (this.attachments.get(key) != null) {
                this.attachments.remove(key);
            }
        });
        oldContents.forEach((key, value) -> {
            String newKey = newParent + "/" + key.substring(key.indexOf(47) + 1);
            this.contents.putIfAbsent(newKey, (List<InputStream>)value);
            if (this.contents.get(key) != null) {
                this.contents.remove(key);
            }
        });
    }

    boolean attachmentExists(Attachment att) {
        return att != null && this.attachments.get(att.getName()) != null && this.contents.get(att.getName()) != null;
    }

    boolean attachmentVersionExists(Attachment att) {
        return this.attachmentExists(att) && this.attachments.get(att.getName()).size() >= att.getVersion() && this.contents.get(att.getName()).size() >= att.getVersion();
    }
}

